/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.AssemblyInfo;
import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreDevice;
import com.integpg.cinema.macro.InternalIOAction;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroExecuter;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.cinema.messaging.EventManagerStatusUpdateSystemMessage;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.utils.RegistryUtils;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import com.integpg.xchange.XChangeConnection;
import com.integpg.xchange.XChangeListener;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Json;
import java.util.Vector;

public class XChangeDevice
extends TheatreDevice
implements XChangeListener,
MacroRequestListener {
    private static XChangeDevice _instance;
    private final Hashtable<String, String> _statuses = new Hashtable();
    private Thread _intermissionTimer;
    private long _intermissionExpire = Long.MAX_VALUE;
    private long lastSendSecond = 0L;

    private XChangeDevice() {
        super("XChangeClient");
        super.setHost("0.0.0.0");
    }

    public static XChangeDevice getInstance() {
        if (_instance == null) {
            System.out.println("xchange device");
            _instance = new XChangeDevice();
            String xchangeHost = RegistryUtils.getRegistryKey("AppData/Cinema/CinemaManagerHost", "none");
            XChangeConnection.getInstance().setHost(xchangeHost);
            XChangeConnection.getInstance().addListener(_instance);
        }
        return _instance;
    }

    public Hashtable<String, String> getStatuses() {
        return this._statuses;
    }

    @Override
    public void clientConnected() throws Exception {
        try {
            String hostname = JANOS.getRegistryString((String)"IpConfig/Hostname", (String)"");
            InetAddress inetAddress = InetAddress.getLocalHost();
            String ipAddress = inetAddress.getHostAddress();
            String connectInfo = hostname + "|" + ipAddress + "|cinema.jnior|" + AssemblyInfo.getVersion();
            XChangeConnection.getInstance().send(String.valueOf(UnitConfig.SERIAL_NUMBER), "connect", connectInfo);
            XChangeConnection.getInstance().sendKnownStatuses(null);
            this.sendMacros(null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void clientDisconnected() throws Exception {
    }

    @Override
    public void clientMessageReceived(Json json) throws Exception {
        System.out.println("Listener received: " + json.toString());
        String source = (String)json.get("source");
        String command = (String)json.get("command");
        String value = (String)json.get("value");
        if (command.equalsIgnoreCase("COMMAND_IO")) {
            InternalIOAction.parseCommand(value);
        } else if (command.equalsIgnoreCase("GET_MACROS")) {
            this.sendMacros(source);
        } else if (command.equalsIgnoreCase("RUN_MACRO")) {
            FileLogger.info("Cinema Manager requesting macro " + value);
            MacroExecuter.runMacro(null, value);
        }
    }

    public void sendMacros(String requester) throws IOException {
        Vector macroNames = CinemaMain.MacroFile.getMacroNumbers();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < macroNames.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            Macro macro = (Macro)macroNames.elementAt(i);
            sb.append(macro.getName());
        }
        XChangeConnection.getInstance().send(String.valueOf(UnitConfig.SERIAL_NUMBER), "macro_names", sb.toString(), requester);
    }

    @Override
    public boolean macroExecute(String macroName) {
        try {
            System.out.println("Cinema Manager Macro Execute");
            String lower = macroName.toLowerCase();
            if (lower.startsWith("send")) {
                String send = macroName.substring(5);
                String data = null;
                String converted = this.convertHexToString(send);
                data = converted != null ? converted : send;
                FileLogger.info(Config.DEVICES_LOG, this.name + " Send " + data);
                if (data == null) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                    return false;
                }
                FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
                int equalPos = data.indexOf(61);
                String key = data.substring(0, equalPos);
                String value = data.substring(equalPos + 1);
                this._statuses.put(key, value);
                this.update(key, value);
            } else if (lower.indexOf("intermission") != -1) {
                if (lower.startsWith("start")) {
                    String data = macroName.substring(19);
                    String seconds = data.substring(0, data.indexOf(59)).trim();
                    String resumeMacro = data.substring(data.indexOf(59) + 1).trim();
                    this.startIntermission(this.getSecondsFromTimeString(seconds) + 1, resumeMacro);
                } else if (lower.startsWith("extend")) {
                    String data = macroName.substring(20);
                    this._intermissionExpire += (long)(this.getSecondsFromTimeString(data) * 1000);
                    String intermissionExtended = "Intermission extended by " + this.getSecondsFromTimeString(data) * 1000 + " seconds";
                    System.out.println(intermissionExtended);
                    FileLogger.info(intermissionExtended);
                } else if (lower.startsWith("shorten")) {
                    String data = macroName.substring(21);
                    this._intermissionExpire -= (long)(this.getSecondsFromTimeString(data) * 1000);
                    String intermissionShortened = "Intermission shortened by " + this.getSecondsFromTimeString(data) * 1000 + " seconds";
                    System.out.println(intermissionShortened);
                    FileLogger.info(intermissionShortened);
                } else if (lower.startsWith("stop")) {
                    this._intermissionTimer.interrupt();
                    String intermissionStopped = "Intermission stopped";
                    System.out.println(intermissionStopped);
                    FileLogger.info(intermissionStopped);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        if (!macroResult.getResult()) {
            FileLogger.warn("Unable to Completly Execute Intermission End Macro: " + macroResult.getReason());
        }
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
    }

    private int getSecondsFromTimeString(String timeString) {
        int colonPos = timeString.indexOf(58);
        return Integer.parseInt(timeString.substring(0, colonPos)) * 60 + Integer.parseInt(timeString.substring(colonPos + 1));
    }

    public void startIntermission(int seconds, final String resumeMacro) {
        long secondsRemaining = seconds;
        long minutesRemaining = secondsRemaining / 60L;
        String secondsString = "0" + String.valueOf(secondsRemaining %= 60L);
        String intermissionStarted = "Intermission Started. (" + String.valueOf(minutesRemaining) + ":" + secondsString.substring(secondsString.length() - 2) + ")";
        System.out.println(intermissionStarted);
        FileLogger.info(intermissionStarted);
        this._intermissionExpire = JANOS.uptimeMillis() + (long)(seconds * 1000);
        if (this._intermissionTimer == null) {
            this._intermissionTimer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (JANOS.uptimeMillis() < XChangeDevice.this._intermissionExpire) {
                            long secondsRemaining = (XChangeDevice.this._intermissionExpire - JANOS.uptimeMillis()) / 1000L;
                            if (XChangeDevice.this.lastSendSecond != secondsRemaining && secondsRemaining % 5L == 0L) {
                                XChangeDevice.this.lastSendSecond = secondsRemaining;
                                long minutesRemaining = secondsRemaining / 60L;
                                String secondsString = "0" + String.valueOf(secondsRemaining %= 60L);
                                try {
                                    XChangeDevice.this.update("status", "Intermission (" + String.valueOf(minutesRemaining) + ":" + secondsString.substring(secondsString.length() - 2) + ")");
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            Thread.sleep(500L);
                        }
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    FileLogger.info("Intermission Complete");
                    XChangeDevice.this.update("status", "Intermission Complete");
                    FileLogger.info("Starting Intermission End Macro: " + resumeMacro);
                    MacroExecuter.runMacro(XChangeDevice.this, resumeMacro);
                    XChangeDevice.this._intermissionTimer = null;
                }
            }, "Intermission Thread");
            this._intermissionTimer.setDaemon(true);
            this._intermissionTimer.start();
        }
    }

    private void update(String key, String value) {
        try {
            EventManagerStatusUpdateSystemMessage systemMsg = new EventManagerStatusUpdateSystemMessage(key, value);
            MessagePumpEngine.postMessage(systemMsg.build());
        }
        catch (Throwable ex) {
            FileLogger.error("error updating event manager statuses");
        }
        try {
            XChangeConnection.getInstance().send(String.valueOf(UnitConfig.SERIAL_NUMBER), "update", String.format("%s = %s", key, value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exceptionThrown(Exception ex) {
        FileLogger.error(ex);
    }
}

