/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.net.http;

import com.integpg.janoslib.debug.ThreadElapsed;
import com.integpg.janoslib.net.http.HttpRequest;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class HttpResponse {
    private final HttpRequest _httpRequest;
    private final Hashtable<String, String> _headers = new Hashtable(32);
    private int _responseCode;
    private String _responseString;
    private String _data;
    private int _length = 0;
    private int _contentLength = -1;

    HttpResponse(HttpRequest httpRequest) {
        this._httpRequest = httpRequest;
        if (this._httpRequest.isDebug()) {
            System.out.println(ThreadElapsed.getElapsed() + "new response");
        }
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public String getResponseString() {
        return this._responseString;
    }

    public String getHeader(String name) {
        return this._headers.get(name);
    }

    public String getData() {
        return this._data;
    }

    public int getResponseLength() {
        return this._length;
    }

    public InputStream getInputStream() throws IOException {
        return this._httpRequest.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse() {
        if (this._httpRequest.isDebug()) {
            System.out.println(ThreadElapsed.getElapsed() + "process response");
        }
        FilterInputStream is = null;
        try {
            String lengthHeader;
            String transferEncoding;
            is = new DataInputStream(this._httpRequest.getInputStream());
            this.processHeaders();
            boolean isChunked = this._headers.containsKey("Transfer-Encoding");
            if (this._httpRequest.isDebug()) {
                System.out.println(ThreadElapsed.getElapsed() + "isChunked: " + isChunked);
            }
            if (isChunked && null != (transferEncoding = this._headers.get("Transfer-Encoding"))) {
                transferEncoding = transferEncoding.trim();
                if (this._httpRequest.isDebug()) {
                    System.out.println(ThreadElapsed.getElapsed() + "transferEncoding: " + transferEncoding);
                }
                isChunked &= "chunked".equalsIgnoreCase(transferEncoding);
                if (this._httpRequest.isDebug()) {
                    System.out.println(ThreadElapsed.getElapsed() + "isChunked: " + isChunked);
                }
            }
            if (null != (lengthHeader = this.getHeader("Content-Length"))) {
                this._contentLength = Integer.valueOf(lengthHeader);
            }
            if (isChunked) {
                this.readChunkedBody();
            } else {
                this.readBody();
            }
            if (this._httpRequest.isDebug()) {
                long elapsed = System.currentTimeMillis() - this._httpRequest.getRequestStart();
                System.out.println(ThreadElapsed.getElapsed() + "elapsed: " + elapsed);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                is.close();
                this._httpRequest.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void processHeaders() {
        if (this._httpRequest.isDebug()) {
            System.out.println(ThreadElapsed.getElapsed() + "process headers");
        }
        DataInputStream is = null;
        try {
            if (this._httpRequest.isDebug()) {
                System.out.println(ThreadElapsed.getElapsed() + "new datainputstream");
            }
            is = new DataInputStream(this._httpRequest.getInputStream());
            if (this._httpRequest.isDebug()) {
                System.out.println(ThreadElapsed.getElapsed() + "read line");
            }
            String header = is.readLine();
            this._length += header.length() + 2;
            this._responseCode = Integer.parseInt(header.substring(9, 12));
            if (this._httpRequest.isDebug()) {
                System.out.println(ThreadElapsed.getElapsed() + "responseCode: " + this._responseCode);
            }
            this._responseString = header.substring(13);
            if (this._httpRequest.isDebug()) {
                System.out.println(ThreadElapsed.getElapsed() + "responseString: " + this._responseString);
            }
            if (this._httpRequest.isDebug()) {
                System.out.println(ThreadElapsed.getElapsed() + "read headers");
            }
            while (!"".equals(header = is.readLine())) {
                this._length += header.length() + 2;
                int colonPos = header.indexOf(":");
                if (-1 >= colonPos) continue;
                String name = header.substring(0, colonPos);
                String value = header.substring(colonPos + 2);
                this._headers.put(name, value);
            }
            if (this._httpRequest.isDebug()) {
                System.out.println(ThreadElapsed.getElapsed() + "headers processed");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readChunkedBody() throws IOException {
        DataInputStream is = new DataInputStream(this._httpRequest.getInputStream());
        StringBuilder sb = new StringBuilder(4096);
        byte[] inBytes = new byte[4096];
        StringBuilder debug = new StringBuilder(4096);
        if (this._httpRequest.isDebug()) {
            debug.append(ThreadElapsed.getElapsed() + "read chunked body\r\n");
        }
        try {
            while (true) {
                int bytesRead;
                String line = is.readLine();
                this._length += line.length() + 2;
                int amountOfDataToFollow = Integer.parseInt(line, 16);
                if (this._httpRequest.isDebug()) {
                    debug.append("amount of data to follow " + line + " = " + amountOfDataToFollow + "\r\n");
                }
                if (0 == amountOfDataToFollow) break;
                while ((bytesRead = is.read(inBytes, 0, Math.min(inBytes.length, amountOfDataToFollow))) > 0) {
                    this._length += bytesRead;
                    sb.append(new String(inBytes, 0, bytesRead));
                    amountOfDataToFollow -= bytesRead;
                }
                line = is.readLine();
                this._length += line.length() + 2;
            }
            if (this._httpRequest.isDebug()) {
                System.out.println(debug.toString());
            }
        }
        catch (Exception ex) {
            System.out.println(debug.toString());
            throw new RuntimeException("incomplete read.\r\n" + sb.toString());
        }
        finally {
            this._data = sb.toString();
        }
    }

    private void readBody() throws IOException {
        InputStream inputStream = this._httpRequest.getInputStream();
        if (this._httpRequest.isDebug()) {
            System.out.println(ThreadElapsed.getElapsed() + "read body");
        }
        StringBuilder sb = new StringBuilder(32768);
        byte[] inBytes = new byte[32768];
        int bytesReadInBody = 0;
        try {
            while (bytesReadInBody < this._contentLength) {
                long timeout = System.currentTimeMillis() + 2500L;
                while (timeout > System.currentTimeMillis() && 0 == inputStream.available()) {
                    Thread.sleep(10L);
                }
                if (this._httpRequest.isDebug()) {
                    System.out.println(ThreadElapsed.getElapsed() + inputStream.available() + " bytes available");
                }
                int bytesRead = inputStream.read(inBytes, 0, inBytes.length);
                bytesReadInBody += bytesRead;
                this._length += bytesRead;
                if (this._httpRequest.isDebug()) {
                    System.out.println(ThreadElapsed.getElapsed() + "read " + bytesRead + " bytes");
                }
                sb.append(new String(inBytes, 0, bytesRead));
            }
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("socket read fail")) {
                // empty if block
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("incomplete read.\r\n" + sb.toString());
        }
        finally {
            this._data = sb.toString();
        }
    }
}

