/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.Logic;
import com.integpg.cinema.client.CinemaServerClient;
import com.integpg.cinema.macro.InternalIOAction;
import com.integpg.cinema.macro.MacroExecuter;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UdpClientHandler {
    private static final Pattern RUN_PATTERN = Pattern.compile("run ([\\w \\.\\-_\\(\\)]+)$", 1);
    private static final Pattern IO_CONTROL_PATTERN = Pattern.compile("\\s*::([copt\\+\\d\\*]+(=\\d+)?)\\s*$", 1);

    private static Matcher getMatcherFor(Pattern pattern, String input) {
        Matcher matcher = pattern.matcher(input);
        return matcher;
    }

    public static void execute(String line) throws IOException {
        System.out.println(line + " (" + line.length() + ")");
        line = StringUtils.trim(line, ' ');
        Matcher matcher = UdpClientHandler.getMatcherFor(IO_CONTROL_PATTERN, line);
        if (matcher.find()) {
            if (1 < matcher.groupCount()) {
                InternalIOAction.parseCommand(matcher.group(1));
            }
        } else if (CinemaServerClient._logicRulesByCommand.containsKey(line)) {
            Logic logic = (Logic)CinemaServerClient._logicRulesByCommand.get(line);
            int result = logic.evaluate(JANOS.getInputStates(), JANOS.getOutputStates());
            if (result == 1) {
                logic.execute();
            }
        } else {
            matcher = RUN_PATTERN.matcher(line);
            boolean found = matcher.find();
            System.out.println("RUN_PATTERN.find(): " + found);
            if (found && 1 < matcher.groupCount()) {
                System.out.println("executing_macro " + matcher.group(1));
                boolean bl = MacroExecuter.runMacro(null, matcher.group(1).trim()).getResult();
            }
        }
    }
}

