/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.messaging;

import com.integpg.cinema.RegistryModifiedListener;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroExecuter;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.cinema.messaging.MacroExecuteResponseSystemMessage;
import com.integpg.janoslib.messagepump.MessagePumpAppMessageListener;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.util.Json;

public class MacroExecuteEventHandler
implements MessagePumpAppMessageListener,
RegistryModifiedListener,
MacroRequestListener {
    @Override
    public void applicationMessageReceived(Json commandJson) {
        FileLogger.info(String.format("%s received %s", this.getClass().getName(), commandJson.toString()));
        try {
            String macroName = commandJson.getString("MacroName");
            if (null != macroName) {
                MacroExecuter.runMacro(this, macroName);
            }
        }
        catch (Throwable ex) {
            FileLogger.error("error processing macro execute handler", ex);
        }
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        MacroExecuteResponseSystemMessage systemMsg = new MacroExecuteResponseSystemMessage().setResult(macroResult.getResult()).setReason(macroResult.getReason());
        if (macroResult.getResult()) {
            systemMsg.setMacro(macroResult.getMacro().getName());
        }
        MessagePumpEngine.postMessage(systemMsg.build());
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
        MacroExecuteResponseSystemMessage systemMsg = new MacroExecuteResponseSystemMessage().setMacro(macro.getName()).setStatus(updateString).build();
        MessagePumpEngine.postMessage(systemMsg);
    }

    @Override
    public void registryModified(String key) {
        String value = JANOS.getRegistryString((String)key, null);
        System.out.println(String.format("MacroExecuteEventHandler: %s = %s", key, value));
        if (null != value) {
            String message;
            Json json = null;
            try {
                json = new Json(value);
            }
            catch (Exception ex) {
                FileLogger.error("error parsing json object for macro.execute: " + value, ex);
            }
            if (null != json && "macro.execute".equals(message = json.getString("Message"))) {
                this.applicationMessageReceived(json);
                JANOS.setRegistryString((String)key, (String)"");
            }
        }
    }
}

