/*
 * Decompiled with CFR 0.152.
 */
package com.barco.pulse.json;

import com.barco.pulse.json.JsonValidator;
import java.util.Json;

public class JsonStream {
    private StringBuffer _buffer = new StringBuffer();
    private final Object LOCK = new Object();

    public void append(String string) {
        this._buffer.append(string);
        this.notifyReader();
    }

    public void append(char c) {
        this._buffer.append(c);
        this.notifyReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReader() {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notifyAll();
        }
    }

    public int length() {
        return this._buffer.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Json getNextJson() throws InterruptedException {
        Object object = this.LOCK;
        synchronized (object) {
            if (0 == this._buffer.length()) {
                this.LOCK.wait();
            }
        }
        JsonValidator jsonValidator = new JsonValidator(this._buffer.toString());
        Json json = null;
        if (jsonValidator.isJsonPresent()) {
            json = jsonValidator.getJsonObject();
            this._buffer = this._buffer.delete(0, jsonValidator.getEndPos() + 1);
        } else if (jsonValidator.isIncomplete()) {
            System.out.println("Incomplete Json object found.");
        }
        return json;
    }

    public String toString() {
        return this._buffer.toString();
    }
}

