/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.utils.ExternalUtils;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;

public class TypeFB
extends ExternalModule {
    private final byte[] _writeBytes = new byte[10];
    private byte _outputsMask;

    public static int getDeviceCountForType() throws IOException {
        return ExternalUtils.getDeviceCountForType("fb");
    }

    public static TypeFB getByIndex(int index) throws IOException {
        return TypeFB.getByNumber(index + 1);
    }

    public static TypeFB getByNumber(int number) throws IOException {
        String deviceAddressString = ExternalUtils.getDeviceAddressFor("fb", number);
        if (!CACHED_DEVICES.containsKey(deviceAddressString)) {
            long address = HexUtils.parseHexAsLong(deviceAddressString);
            CACHED_DEVICES.put(deviceAddressString, new TypeFB(address, number));
        }
        return (TypeFB)CACHED_DEVICES.get(deviceAddressString);
    }

    TypeFB(long address) {
        super(address, -1, "TypeFB");
    }

    TypeFB(long address, int index) {
        super(address, index, "TypeFB");
    }

    @Override
    public void read() throws IOException {
        this._dataBlock = JANOS.readDeviceBlock((long)this.Address);
        this._outputsMask = this._dataBlock[1];
    }

    public int getOutputs() {
        return this._outputsMask;
    }

    public void setOutput(int channel, boolean state) {
    }

    public void setOutputs(int stateMask, int channelMask) {
        this._writeBytes[0] = (byte)(channelMask & 0xFF);
        this._writeBytes[1] = (byte)(stateMask & 0xFF);
        ArrayUtils.setLong((byte[])this._writeBytes, (int)2, (long)0L);
        try {
            JANOS.writeDeviceBlock((long)this.Address, (byte[])this._writeBytes);
            this._outputsMask = this._writeBytes[1];
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void pulseOutputs(int stateMask, int channelMask, int duration) {
        this._writeBytes[0] = (byte)(channelMask & 0xFF);
        this._writeBytes[1] = (byte)(stateMask & 0xFF);
        for (int i = 0; i < 4; ++i) {
            ArrayUtils.setShort((byte[])this._writeBytes, (int)(2 + i * 2), (short)((short)duration));
        }
        try {
            JANOS.writeDeviceBlock((long)this.Address, (byte[])this._writeBytes);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void printValues() {
    }

    @Override
    public Object get(String filedName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

