/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.webhandlers;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroExecuter;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.janoslib.net.http.server.HttpContext;
import com.integpg.janoslib.net.http.server.HttpResponse;
import com.integpg.janoslib.net.http.server.WebHandler;
import com.integpg.logger.FileLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class MacroExecuteWebHandler
implements WebHandler,
MacroRequestListener {
    private PrintWriter _out;

    @Override
    public void processRequest(HttpContext httpContext) {
        try {
            System.out.println(String.format("%lld MacroExecuteWebHandler request received", System.currentTimeMillis()));
            FileLogger.info(String.format("Processing %s", httpContext.getRequest().getRequestedURI()));
            HttpResponse response = httpContext.getResponse();
            response.setContentType("text/html");
            this._out = response.getWriter();
            Hashtable<String, String> queryParams = httpContext.getRequest().getQueryParams();
            if (0 < queryParams.size()) {
                Enumeration<String> e = queryParams.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    String value = queryParams.get(key);
                    this._out.println(String.format("%s = %s", key, value));
                    this._out.println("<br>");
                }
                this._out.println("<br>");
            }
            try {
                String macroName = queryParams.get("name");
                if (null != macroName) {
                    MacroExecuter.runMacro(this, macroName);
                } else {
                    StringBuffer sb = new StringBuffer();
                    Hashtable macroNamesHash = CinemaMain.MacroFile.getMacroNames();
                    if (0 < macroNamesHash.size()) {
                        Enumeration e = macroNamesHash.elements();
                        while (e.hasMoreElements()) {
                            if (0 < sb.length()) {
                                sb.append(',');
                            }
                            Macro macro = (Macro)e.nextElement();
                            sb.append(macro.getName());
                        }
                    } else {
                        sb.append("There are not any macros loaded");
                    }
                    this._out.println(sb.toString());
                }
            }
            catch (Exception ex) {
                this._out.println("error: " + ex.getMessage());
                ex.printStackTrace();
            }
            System.out.println(String.format("%lld MacroExecuteWebHandler request done", System.currentTimeMillis()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                httpContext.getRequest().close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        this._out.println(new Date() + " - " + macroResult.getResult() + ": " + macroResult.getReason());
        this._out.println("<br>");
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
        this._out.println(new Date() + " - " + updateString);
        this._out.println("<br>");
    }
}

