/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.logger.FileLogger;
import java.io.IOException;

public class DoremiDcp
extends TheatreEthernetDevice {
    private static final byte[] PLAY_BYTES = HexUtils.unescapeString("\\x06\\x0e\\x2b\\x34\\x02\\x05\\x01\\x0a\\x0e\\x10\\x01\\x01\\x01\\x03\\x0B\\x00\\x83\\x00\\x00\\x04\\x00\\x00\\x00\\x01");
    private static final byte[] PAUSE_BYTES = HexUtils.unescapeString("\\x06\\x0e\\x2b\\x34\\x02\\x05\\x01\\x0a\\x0e\\x10\\x01\\x01\\x01\\x03\\x0D\\x00\\x83\\x00\\x00\\x04\\x00\\x00\\x00\\x01");
    private static final byte[] EJECT_BYTES = HexUtils.unescapeString("\\x06\\x0e\\x2b\\x34\\x02\\x05\\x01\\x0a\\x0e\\x10\\x01\\x01\\x01\\x03\\x0F\\x00\\x83\\x00\\x00\\x04\\x00\\x00\\x00\\x01");
    private static final byte[] SHUTDOWN_BYTES = HexUtils.unescapeString("\\x06\\x0E\\x2B\\x34\\x02\\x05\\x01\\x0A\\x0E\\x10\\x01\\x01\\x01\\x05\\x17\\x00\\x83\\x00\\x00\\x06\\x00\\x00\\x00\\x01\\x01\\x00");
    private static final byte[] REBOOT_BYTES = HexUtils.unescapeString("\\x06\\x0E\\x2B\\x34\\x02\\x05\\x01\\x0A\\x0E\\x10\\x01\\x01\\x01\\x05\\x17\\x00\\x83\\x00\\x00\\x06\\x00\\x00\\x00\\x01\\x02\\x00");

    public DoremiDcp(String name) {
        super(name);
        this._port = "11730";
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean sendNamedCommand(String commandName) {
        FileLogger.info(Config.DEVICES_LOG, "Doremi DCP macro: " + commandName + " (" + commandName.length() + ")");
        try {
            if (commandName.equalsIgnoreCase("play")) {
                if (this.send(PLAY_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Play");
                    return true;
                }
            } else if (commandName.equalsIgnoreCase("pause")) {
                if (this.send(PAUSE_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Pause");
                    return true;
                }
            } else if (commandName.equalsIgnoreCase("eject")) {
                if (this.send(EJECT_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Eject");
                    return true;
                }
            } else if (commandName.equalsIgnoreCase("shutdown")) {
                if (this.send(SHUTDOWN_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Shutdown");
                    return true;
                }
            } else if (commandName.equalsIgnoreCase("reboot")) {
                if (this.send(REBOOT_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Reboot");
                    return true;
                }
            } else if (commandName.toLowerCase().startsWith("send")) {
                return super.doSend(commandName);
            }
            throw new RuntimeException("Unknown command");
        }
        catch (Exception ex) {
            FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending " + commandName, ex);
            return false;
        }
    }

    private int getMacroNumberFromName(String macroName) {
        System.out.println("macro name: " + macroName);
        int lastSpace = macroName.lastIndexOf(32);
        String macroNumberString = macroName.substring(lastSpace + 1);
        System.out.println("last space: " + lastSpace + ", macroNumberString: " + macroNumberString);
        return Integer.parseInt(macroNumberString);
    }

    @Override
    public synchronized boolean send(byte[] dataBytes) {
        this.ensureConnection();
        boolean success = true;
        try {
            FileLogger.info(Config.DEVICES_LOG, this.name + " Send " + HexUtils.bytesToHex(dataBytes));
            this.bos.reset();
            this.bos.write(dataBytes);
            this.out.write(this.bos.toByteArray());
        }
        catch (IOException ex) {
            FileLogger.error(ex);
            try {
                this.disconnect();
                if (this.ensureConnection()) {
                    this.out.write(this.bos.toByteArray());
                } else {
                    success = false;
                }
            }
            catch (IOException ex2) {
                FileLogger.error(ex2);
                this.disconnect();
                success = false;
            }
        }
        return success;
    }
}

