/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.BarcoSeries4;
import com.integpg.cinema.devices.DoremiDcp;
import com.integpg.cinema.devices.QSCDCP300Ethernet;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.logger.FileLogger;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class RawEthernet
extends TheatreEthernetDevice {
    private boolean _inUse = false;

    public RawEthernet(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendNamedCommand(String commandName) {
        block37: {
            try {
                System.out.println("RawEthernet: macroName = " + commandName);
                String newTermString = "";
                boolean backslashFound = false;
                if (this.terminationString != null) {
                    for (int i = 0; i < this.terminationString.length(); ++i) {
                        if (this.terminationString.charAt(i) == '\\' && !backslashFound) {
                            backslashFound = true;
                            continue;
                        }
                        if (backslashFound) {
                            switch (this.terminationString.charAt(i)) {
                                case 'r': {
                                    newTermString = newTermString + '\r';
                                    break;
                                }
                                case 'n': {
                                    newTermString = newTermString + '\n';
                                    break;
                                }
                                case 't': {
                                    newTermString = newTermString + '\t';
                                    break;
                                }
                                case 'f': {
                                    newTermString = newTermString + '\f';
                                    break;
                                }
                                case 'b': {
                                    newTermString = newTermString + '\b';
                                    break;
                                }
                                case '0': {
                                    newTermString = newTermString + '\u0000';
                                }
                            }
                        } else {
                            newTermString = newTermString + this.terminationString.charAt(i);
                        }
                        backslashFound = false;
                    }
                }
                if (!commandName.startsWith("send")) break block37;
                String data = commandName.substring(5);
                String lowerCaseData = data.toLowerCase();
                String commandName2 = null;
                if (lowerCaseData.startsWith("command:")) {
                    commandName2 = lowerCaseData.substring(8).trim();
                } else if (lowerCaseData.startsWith("{{") && lowerCaseData.endsWith("}}")) {
                    commandName2 = lowerCaseData.substring(2, lowerCaseData.length() - 2);
                }
                if (null != commandName2) {
                    FileLogger.info(String.format("command: found for %s is %s", this.getName(), commandName2));
                    String lowerCaseDevice = this.getName().toLowerCase();
                    if (lowerCaseDevice.contains("_")) {
                        lowerCaseDevice = lowerCaseDevice.substring(0, lowerCaseDevice.indexOf("_"));
                    }
                    TheatreEthernetDevice device = null;
                    switch (lowerCaseDevice) {
                        case "barcoseries4": {
                            device = new BarcoSeries4(this.getName());
                            break;
                        }
                        case "doremidcp": {
                            device = new DoremiDcp(this.getName());
                            break;
                        }
                        case "qscdcp300": {
                            device = new QSCDCP300Ethernet(this.getName());
                        }
                    }
                    if (null != device) {
                        device.setHost(this._host);
                        device.setPort(this._port);
                        boolean deviceMacroSuccess = false;
                        try {
                            deviceMacroSuccess = device.sendNamedCommand(commandName2);
                        }
                        finally {
                            device.disconnect();
                        }
                        return deviceMacroSuccess;
                    }
                }
                if (newTermString != null) {
                    data = data + newTermString;
                }
                if (data == null) {
                    FileLogger.warn(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                    return false;
                }
                FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + commandName.trim());
                byte[] dataBytes = null;
                if (data.toUpperCase().startsWith("HEX")) {
                    data = this.convertHexToString(data);
                }
                dataBytes = HexUtils.unescapeString(data);
                this.send(dataBytes);
            }
            catch (RuntimeException ex) {
                FileLogger.error("Cinema.jnior: Raw Ethernet Execute macro Too Many Threads.", ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(byte[] bytes) {
        if (this._host.equals("255.255.255.255")) {
            try {
                InetAddress address = InetAddress.getByName(this._host);
                DatagramSocket ds = new DatagramSocket();
                DatagramPacket dp = new DatagramPacket(bytes, bytes.length, address, Integer.parseInt(this._port));
                ds.send(dp);
                ds.close();
            }
            catch (Exception ex) {
                FileLogger.error("Error sending UDP in raw ethernet: " + ex.getMessage());
            }
            return true;
        }
        RawEthernet ex = this;
        synchronized (ex) {
            this.ensureConnection();
            this._inUse = true;
        }
        try {
            if (this.out != null) {
                this.out.write(bytes);
                this.out.flush();
            }
        }
        catch (Exception ex3) {
            FileLogger.error(ex3);
            super.disconnect();
            this.ensureConnection();
            try {
                if (this.out != null) {
                    this.out.write(bytes);
                    this.out.flush();
                }
            }
            catch (IOException ex2) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Could not send to " + this.name);
            }
        }
        RawEthernet rawEthernet = this;
        synchronized (rawEthernet) {
            this._inUse = false;
        }
        return true;
    }

    @Override
    public boolean login() {
        return false;
    }
}

