/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integpg.logger.FileLogger;
import com.integpg.system.Immutable;
import java.io.IOException;

public class BootInfo {
    public static int increment() {
        int rebootCount = 0;
        Immutable immutableReboot = null;
        try {
            immutableReboot = BootInfo.openImmutable("BOOTINFO", 8);
            rebootCount = (int)immutableReboot.readLong(0);
            immutableReboot.writeLong(0, (long)(++rebootCount));
            immutableReboot.close();
        }
        catch (IOException ex) {
            FileLogger.error("Error updating reboot count", ex);
        }
        return rebootCount;
    }

    private static Immutable openImmutable(String name, int size) throws IOException {
        Immutable immutable;
        if (name.length() != 8) {
            throw new IllegalArgumentException("Name argument wrong length.  Must be 8 chars.");
        }
        if (size > 65520) {
            size = 65520;
        }
        if (!(immutable = new Immutable()).exists(name)) {
            immutable.create(name, size);
            System.out.println("Initialized Immutable Data Store - " + name + " (" + size + ")");
        } else {
            immutable.open(name);
            if (immutable.size() != size) {
                Immutable.remove((String)name);
                immutable.create(name, size);
                System.out.println("Reinitialized Immutable Data Store - " + name + " (" + size + ")");
            }
        }
        return immutable;
    }
}

