/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integpg.cinema.Rebooter;
import com.integpg.cinema.configuration.ScheduledConfig;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroExecuter;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.logger.FileLogger;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.TimerTask;

public class ScheduleTask
extends TimerTask
implements MacroRequestListener {
    public ScheduledConfig _config;

    public ScheduleTask(ScheduledConfig config) {
        this._config = config;
    }

    @Override
    public void run() {
        if (this._config.shouldExecute()) {
            String lowerCaseAction = this._config.getAction().toLowerCase();
            if (lowerCaseAction.startsWith("reboot")) {
                FileLogger.info("Sending reboot command");
                try {
                    Rebooter.sendReboot(lowerCaseAction.endsWith("a"));
                }
                catch (SocketException ex) {
                    ex.printStackTrace();
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else if (MacroExecuter.runMacro(this, this._config.getAction()).getResult()) {
                FileLogger.info("Executed Scheduled Macro - " + this._config.getAction());
            }
        }
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        if (!macroResult.getResult()) {
            FileLogger.info("Scheduled macro could not execute: " + macroResult.getReason());
        }
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
    }
}

