/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.net.http.HttpConnection;
import com.integpg.janoslib.net.http.HttpPostRequest;
import com.integpg.janoslib.net.http.HttpResponse;
import com.integpg.janoslib.net.http.HttpURL;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class HttpRequest
extends TheatreEthernetDevice {
    public HttpRequest(String name) {
        super(name);
    }

    @Override
    public boolean macroExecute(String macroName) {
        System.out.println("macroName: " + macroName);
        if (macroName.toLowerCase().startsWith("get")) {
            String send = macroName.substring(4);
            String data = null;
            String converted = this.convertHexToString(send);
            data = converted != null ? converted : send;
            if (data == null) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            byte[] dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
            return this.send("GET", dataBytes);
        }
        if (macroName.toLowerCase().startsWith("put")) {
            String send = macroName.substring(4);
            String data = null;
            String converted = this.convertHexToString(send);
            data = converted != null ? converted : send;
            if (data == null) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            byte[] dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
            return this.send("GET", dataBytes);
        }
        if (macroName.toLowerCase().startsWith("post")) {
            String send = macroName.substring(5);
            String data = null;
            String converted = this.convertHexToString(send);
            data = converted != null ? converted : send;
            if (data == null) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            byte[] dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
            try {
                String urlString = String.format("%s://%s:%s", "443".equals(this._port) ? "https" : "http", this._host, this._port);
                String dataString = new String(dataBytes);
                String dataPayloadString = null;
                int dashDataPos = dataString.indexOf(" -data ");
                if (-1 != dashDataPos) {
                    dataPayloadString = dataString.substring(dashDataPos + 7);
                    dataString = dataString.substring(0, dashDataPos);
                }
                if (!dataString.startsWith("/")) {
                    urlString = urlString + "/";
                }
                urlString = urlString + dataString;
                System.out.println("urlString: " + urlString);
                HttpURL url = new HttpURL(urlString);
                HttpPostRequest httpPost = new HttpPostRequest(url);
                httpPost.setDebug(true);
                if (null != dataPayloadString) {
                    System.out.println("dataPayloadString: " + dataPayloadString);
                    httpPost.setData(dataPayloadString.getBytes());
                }
                HttpResponse httpResponse = httpPost.sendRequest();
                httpResponse.processResponse();
                String response = httpResponse.getData();
                System.out.println("httpResponse: " + response);
                FileLogger.info(Config.DEVICES_LOG, this.name + " http post response: " + httpResponse.getResponseString());
                return true;
            }
            catch (IOException ex) {
                FileLogger.error(Config.DEVICES_LOG, ex);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean login() {
        return false;
    }

    public boolean send(String method, byte[] dataBytes) {
        try {
            String urlString = "http://" + this._host + ":" + this._port;
            String dataString = new String(dataBytes);
            if (!dataString.startsWith("/")) {
                urlString = urlString + "/";
            }
            urlString = urlString + dataString;
            System.out.println("urlString: " + urlString);
            HttpURL url = new HttpURL(urlString);
            HttpConnection httpConnection = new HttpConnection(url);
            httpConnection.setRequestMethod(method);
            httpConnection.connect();
            httpConnection.sendHeaders();
            httpConnection.sendData();
            httpConnection.close();
            return true;
        }
        catch (IOException ex) {
            FileLogger.error(Config.DEVICES_LOG, ex);
            return false;
        }
    }
}

