/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.logger.FileLogger;
import java.io.IOException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QSCDCP300Ethernet
extends TheatreEthernetDevice {
    private static byte[] ZEROS = new byte[]{0, 0, 0, 0, 0};
    private static final String ACTIVE_AUDIO_PRESET = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x00290000\" M=\"0\" S=\"{VALUE}\"/></SET_S>";
    private static final String ACTIVE_CONTROL_PRESET = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x002E0000\" M=\"0\" S=\"{VALUE}\"/></SET_S>";
    private static final String MASTER_GAIN = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x001B0000\" M=\"0\" F=\"{VALUE}\"/></SET_S>";
    private static final String MASTER_MUTE = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x001C0000\" M=\"0\" B=\"{VALUE}\"/></SET_S>";
    private static final String MASTER_AMP_POWER_ON = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x001D0000\" M=\"0\" B=\"true\"/></SET_S>";
    private static final String MASTER_AMP_POWER_STANDBY = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x002F0000\" M=\"0\" B=\"true\"/></SET_S>";
    private static final String MASTER_MUTE_QUERY = "<?xml version=\"1.0\"?><!--0000104--><GET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><EGS O=\"0x001C0000\" M=\"0\"/></GET_S>";
    private static final String MASTER_MUTE_ON = "<?xml version=\"1.0\"?><!--0000113--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x001C0000\" M=\"0\" B=\"true\"/></SET_S>";
    private static final String MASTER_MUTE_OFF = "<?xml version=\"1.0\"?><!--0000114--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x001C0000\" M=\"0\" B=\"false\"/></SET_S>";

    public QSCDCP300Ethernet(String name) {
        super(name);
        this._port = "4446";
    }

    @Override
    public boolean login() {
        return true;
    }

    private synchronized boolean toggleMute() {
        try {
            if (this.send(MASTER_MUTE_QUERY.getBytes())) {
                FileLogger.info(Config.DEVICES_LOG, this.name + " Query Mute status sent");
                this.socket.setSoTimeout(2000);
                StringBuilder sb = new StringBuilder();
                while (!sb.toString().endsWith("</GETACK_S>")) {
                    int b = this.in.read();
                    sb.append((char)b);
                }
                String response = sb.toString();
                FileLogger.info(Config.DEVICES_LOG, "response = " + response);
                Pattern pattern = Pattern.compile("B=\"(\\w*)\"");
                Matcher matcher = pattern.matcher(response);
                if (null != matcher && matcher.find()) {
                    String newMuteCommand = MASTER_MUTE_OFF;
                    String booleanStateString = matcher.group(1);
                    FileLogger.info(Config.DEVICES_LOG, "booleanStateString = " + booleanStateString);
                    boolean muteState = Boolean.valueOf(booleanStateString);
                    if (!muteState) {
                        newMuteCommand = MASTER_MUTE_ON;
                    }
                    if (this.send(newMuteCommand.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " New Mute status sent: " + newMuteCommand);
                        return true;
                    }
                    FileLogger.info(Config.DEVICES_LOG, this.name + " New Mute status was not sent");
                }
            } else {
                FileLogger.info(Config.DEVICES_LOG, this.name + " Query Mute status was not sent");
            }
        }
        catch (IOException ex) {
            FileLogger.error("error toggling qsc mute state", ex);
        }
        return false;
    }

    private String replace(String original, String search, String newString) {
        String s = null;
        int pos = original.indexOf(search);
        if (pos >= 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(original.substring(0, pos));
            sb.append(newString);
            sb.append(original.substring(pos + search.length()));
            s = sb.toString();
        } else {
            s = original;
        }
        return s;
    }

    private String getLengthString(int length) {
        String lengthString = "0000000" + String.valueOf(length);
        lengthString = lengthString.substring(lengthString.length() - 7, lengthString.length());
        return lengthString;
    }

    @Override
    public synchronized boolean sendNamedCommand(String commandName) {
        System.out.println(new Date().toString() + "QSCDCP300 macro: " + commandName);
        if (commandName.toLowerCase().startsWith("active audio preset")) {
            try {
                commandName = this.replace(ACTIVE_AUDIO_PRESET, "{VALUE}", commandName.substring(20));
                commandName = this.replace(commandName, "{-LEN-}", this.getLengthString(commandName.length()));
                if (this.send(commandName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Active audio preset Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Active audio preset");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Active audio preset");
            }
        } else if (commandName.toLowerCase().startsWith("active control preset")) {
            try {
                commandName = this.replace(ACTIVE_CONTROL_PRESET, "{VALUE}", commandName.substring(22));
                commandName = this.replace(commandName, "{-LEN-}", this.getLengthString(commandName.length()));
                if (this.send(commandName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Active control preset Adjusted");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Active control preset");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Active control preset");
            }
        } else if (commandName.toLowerCase().startsWith("master gain")) {
            try {
                commandName = this.replace(MASTER_GAIN, "{VALUE}", commandName.substring(12));
                commandName = this.replace(commandName, "{-LEN-}", this.getLengthString(commandName.length()));
                if (this.send(commandName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Master gain Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master gain");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master gain");
            }
        } else if (commandName.toLowerCase().startsWith("master mute")) {
            try {
                commandName = this.replace(MASTER_MUTE, "{VALUE}", commandName.substring(12));
                commandName = this.replace(commandName, "{-LEN-}", this.getLengthString(commandName.length()));
                if (this.send(commandName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Master mute Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master mute");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master mute");
            }
        } else if (commandName.toLowerCase().startsWith("master amp power on")) {
            try {
                commandName = MASTER_AMP_POWER_ON;
                commandName = this.replace(commandName, "{-LEN-}", this.getLengthString(commandName.length()));
                if (this.send(commandName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Master amp power on Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master amp power on");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master amp power on");
            }
        } else if (commandName.toLowerCase().startsWith("master amp power standby")) {
            try {
                commandName = MASTER_AMP_POWER_STANDBY;
                commandName = this.replace(commandName, "{-LEN-}", this.getLengthString(commandName.length()));
                if (this.send(commandName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Master amp power standby Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master amp power standby");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master amp power standby");
            }
        } else {
            if (commandName.toLowerCase().startsWith("toggle_mute")) {
                return this.toggleMute();
            }
            if (commandName.toLowerCase().startsWith("send")) {
                return super.doSend(commandName);
            }
        }
        return false;
    }

    @Override
    public synchronized boolean send(byte[] dataBytes) {
        if (this.ensureConnection()) {
            try {
                if (dataBytes == null) {
                    System.out.println(this.name + " databytes null");
                }
                this.bos.reset();
                this.bos.write(dataBytes);
                this.out.write(this.bos.toByteArray());
            }
            catch (IOException ex) {
                FileLogger.error(ex);
                try {
                    this.disconnect();
                    if (!this.ensureConnection()) {
                        this.disconnect();
                        return false;
                    }
                    this.out.write(this.bos.toByteArray());
                }
                catch (IOException ex2) {
                    FileLogger.error(ex2);
                    this.disconnect();
                    return false;
                }
            }
        } else {
            System.out.println("Could not connect");
            return false;
        }
        return true;
    }
}

