/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.integpg.janoslib.threading.ThreadPool;
import com.integpg.logger.FileLogger;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TaskQueue;
import java.util.TimerTask;

class TimerThread
extends Thread {
    boolean newTasksMayBeScheduled = true;
    private TaskQueue queue;

    TimerThread(TaskQueue queue) {
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mainLoop();
        }
        finally {
            TaskQueue taskQueue = this.queue;
            synchronized (taskQueue) {
                this.newTasksMayBeScheduled = false;
                this.queue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        Calendar cal = Calendar.getInstance();
        SimpleTimeZone tz = (SimpleTimeZone)cal.getTimeZone();
        long tzOffset = tz.getOffset(1, cal.get(1), cal.get(2), cal.get(5), cal.get(7), cal.get(11) * 3600000 + cal.get(12) * 60000 + cal.get(13) * 1000);
        boolean isDST = tz.inDaylightTime(new Date());
        block8: while (true) {
            try {
                while (true) {
                    boolean taskFired;
                    TimerTask task;
                    TaskQueue taskQueue = this.queue;
                    synchronized (taskQueue) {
                        long currentTime;
                        long executionTime;
                        while (this.queue.isEmpty() && this.newTasksMayBeScheduled) {
                            this.queue.wait();
                        }
                        if (this.queue.isEmpty()) {
                            System.out.println("Queue empty, die");
                            break block8;
                        }
                        task = this.queue.getMin();
                        Object object = task.lock;
                        synchronized (object) {
                            if (task.state == 3) {
                                this.queue.removeMin();
                                continue;
                            }
                            executionTime = task.nextExecutionTime;
                            currentTime = System.currentTimeMillis();
                            taskFired = executionTime <= currentTime;
                            if (taskFired) {
                                if (task.period == 0L) {
                                    this.queue.removeMin();
                                    task.state = 2;
                                } else if (task.period < 0L) {
                                    this.queue.rescheduleMin(currentTime - task.period);
                                } else if (isDST != tz.inDaylightTime(new Date(executionTime + task.period))) {
                                    long _tzOffset = tz.getOffset(1, cal.get(1), cal.get(2), cal.get(5), cal.get(7), cal.get(11) * 3600000 + cal.get(12) * 60000 + cal.get(13) * 1000);
                                    long tzChange = tzOffset + _tzOffset;
                                    this.queue.rescheduleMin(executionTime + task.period + tzChange);
                                    isDST = tz.inDaylightTime(new Date(executionTime + task.period));
                                    tzOffset = _tzOffset;
                                } else {
                                    this.queue.rescheduleMin(executionTime + task.period);
                                }
                            }
                        }
                        if (!taskFired) {
                            this.queue.wait(executionTime - currentTime);
                        }
                    }
                    if (!taskFired) continue;
                    ThreadPool.execute(task);
                }
            }
            catch (InterruptedException ex) {
                FileLogger.error(ex);
                continue;
            }
            break;
        }
    }
}

