/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;

public class NEC
extends TheatreEthernetDevice {
    private static final byte[] POWER_OFF_BYTES = new byte[]{2, 1, 0, 0, 0, 3};
    private static final byte[] POWER_ON_BYTES = new byte[]{2, 0, 0, 0, 0, 2};
    private static final byte[] LAMP_OFF_BYTES = new byte[]{3, 47, 0, 0, 2, 18, 2, 72};
    private static final byte[] LAMP_ON_BYTES = new byte[]{3, 47, 0, 0, 2, 18, 1, 71};
    private static final byte[] OPEN_DOUSER_BYTES = new byte[]{2, 23, 0, 0, 0, 25};
    private static final byte[] CLOSE_DOUSER_BYTES = new byte[]{2, 22, 0, 0, 0, 24};
    private static final byte[] INPUT_SWITCH_BYTES = new byte[]{2, 3, 0, 0, 2, 0, 0, 0};

    public NEC(String name) {
        super(name);
        this._port = "7142";
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        System.out.println("NEC macro: " + macroName);
        if (macroName.toLowerCase().equals("power on")) {
            try {
                if (this.send(POWER_ON_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Power On");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Power On");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Power On");
            }
        } else if (macroName.toLowerCase().equals("power off")) {
            try {
                if (this.send(POWER_OFF_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Power Off");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Power Off");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Power Off");
            }
        } else if (macroName.toLowerCase().equals("close dowser")) {
            try {
                if (this.send(CLOSE_DOUSER_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Closing Dowser");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Closing Dowser");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Closing Dowser");
            }
        } else if (macroName.toLowerCase().equals("open dowser")) {
            try {
                if (this.send(OPEN_DOUSER_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Opening Dowser");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Opening Dowser");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Opening Dowser");
            }
        } else if (macroName.toLowerCase().equals("lamp off")) {
            try {
                if (this.send(LAMP_OFF_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Lamp Off");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Lamp Off");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Lamp Off");
            }
        } else if (macroName.toLowerCase().equals("lamp on")) {
            try {
                if (this.send(LAMP_ON_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Lamp On");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Lamp On");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Lamp On");
            }
        } else if (macroName.toLowerCase().startsWith("input switch")) {
            NEC.INPUT_SWITCH_BYTES[5] = 6;
            int input = this.getMacroNumberFromName(macroName);
            NEC.INPUT_SWITCH_BYTES[6] = (byte)(input - 1);
            NEC.INPUT_SWITCH_BYTES[7] = 0;
            for (int i = 0; i < 7; ++i) {
                INPUT_SWITCH_BYTES[7] = (byte)(INPUT_SWITCH_BYTES[7] + INPUT_SWITCH_BYTES[i]);
            }
            try {
                if (this.send(INPUT_SWITCH_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Switching Input to " + input);
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Switching Input");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Switching Input");
            }
        } else {
            if (macroName.toLowerCase().startsWith("send")) {
                String send = macroName.substring(5);
                String data = null;
                String converted = this.convertHexToString(send);
                data = converted != null ? converted : send;
                if (data == null) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                    return false;
                }
                int dataLen = data.length();
                byte[] dataBytes = new byte[dataLen];
                ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
                return this.send(dataBytes);
            }
            FileLogger.warn("Unknown command");
        }
        return false;
    }

    private int getMacroNumberFromName(String macroName) {
        System.out.println("macro name: " + macroName);
        int lastSpace = macroName.lastIndexOf(32);
        String macroNumberString = macroName.substring(lastSpace + 1);
        System.out.println("last space: " + lastSpace + ", macroNumberString: " + macroNumberString);
        return Integer.parseInt(macroNumberString);
    }

    public synchronized boolean send(byte[] dataBytes) {
        this.ensureConnection();
        boolean success = true;
        try {
            this.bos.reset();
            this.bos.write(dataBytes);
            this.out.write(this.bos.toByteArray());
        }
        catch (IOException ex) {
            FileLogger.error(ex);
            try {
                this.disconnect();
                if (this.ensureConnection()) {
                    this.out.write(this.bos.toByteArray());
                } else {
                    success = false;
                }
            }
            catch (IOException ex2) {
                FileLogger.error(ex2);
                this.disconnect();
                success = false;
            }
        }
        if (success) {
            try {
                long start = JANOS.uptimeMillis();
                while (JANOS.uptimeMillis() - start < 10000L && this.in.available() < 6) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        FileLogger.error(ex);
                    }
                }
                if (this.in.available() > 0) {
                    byte[] inBytes = new byte[128];
                    int bytesRead = this.in.read(inBytes);
                    String hex = HexUtils.hexDump(inBytes, 0, bytesRead);
                    String bytesBack = bytesRead + " bytes back from nec " + hex;
                    System.out.println(bytesBack);
                    FileLogger.info(Config.DEVICES_LOG, this.name + " " + bytesBack);
                    if (inBytes[0] == 34) {
                        success = true;
                    } else if (inBytes[0] == 162) {
                        success = false;
                    }
                }
            }
            catch (IOException ex) {
                FileLogger.error(ex);
                this.disconnect();
            }
        }
        return success;
    }
}

