/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.macro;

import java.util.TimerTask;

public abstract class MacroAction
extends TimerTask {
    private int _delay;
    protected String _action;
    protected String _originalAction;
    protected String _lowerCaseAction;
    protected boolean _completed = false;
    protected boolean _success = false;

    protected MacroAction(String action, int delay) {
        this._originalAction = action;
        this._action = action.indexOf("\\") != -1 ? new String(this.getTerminationBytes(action)) : action;
        this._lowerCaseAction = action.toLowerCase();
        this._delay = delay;
    }

    @Override
    public void run() {
        this._completed = true;
    }

    public int getDelay() {
        return this._delay;
    }

    public boolean isCompleted() {
        return this._completed;
    }

    public boolean isSuccessful() {
        return this._success;
    }

    public void setAction(String action) {
        this._action = action;
        this._lowerCaseAction = action.toLowerCase();
    }

    public String getAction() {
        return this._action;
    }

    protected byte[] getTerminationBytes(String terminationString) {
        String newTermString = "";
        boolean backslashFound = false;
        for (int i = 0; i < terminationString.length(); ++i) {
            if (terminationString.charAt(i) == '\\' && !backslashFound) {
                backslashFound = true;
                continue;
            }
            if (backslashFound) {
                switch (terminationString.charAt(i)) {
                    case 'r': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'n': {
                        newTermString = newTermString + '\n';
                        break;
                    }
                    case 't': {
                        newTermString = newTermString + '\t';
                        break;
                    }
                    case 'f': {
                        newTermString = newTermString + '\f';
                        break;
                    }
                    case 'b': {
                        newTermString = newTermString + '\b';
                        break;
                    }
                    case '0': {
                        newTermString = newTermString + '\u0000';
                        break;
                    }
                    case 'x': {
                        String s = terminationString.substring(i + 1, i + 3);
                        newTermString = newTermString + (char)Integer.parseInt(s, 16);
                        i += 2;
                    }
                }
            } else {
                newTermString = newTermString + terminationString.charAt(i);
            }
            backslashFound = false;
        }
        return newTermString.getBytes();
    }
}

