App.controller('schedule', ['$scope', function ($scope) {

    var _this = this;

    jnrwebsocket.addOnLoggedInListener(function onLoggedIn() {
        console.log("schedule on load called")
        _this.config = {
            schedule: []
        }
        _this.savedConfig;
        _this.Version;
        jnrwebsocket.getRegistryListing('AppData/Cinema/Schedule', function (registryKey, registryValues) {
            var values = [];
            values = registryValues;
            jnrwebsocket.readRegistryKeys(values, function (registryKey, registryValue) {
                _this.config.schedule.push({ regname: registryKey, output: registryValue });
                _this.savedConfig = angular.copy(_this.config);
                $scope.$apply();
            });
        })
    });

    _this.addSchedule = function () {
        var newRule = prompt("Enter the name of the new schedule rule");
        if (newRule == "") {
            alert("A name for the new registry key is required.");
            _this.addSchedule();
        }
        else if (!/^[0-9a-zA-Z_]+$/.test(newRule)) {
            alert("Registry name may only contatin letters, numbers, and underscores.")
            _this.addSchedule();
        }
        else if (newRule != null) {
            _this.config.schedule.push({ regname: 'AppData/Cinema/Schedule/' + newRule, output: 'none' });
        }
    };

    _this.removeSchedule = function (reg) {
        index = _this.config.schedule.indexOf(reg);
        _this.config.schedule[index].output = "";
    };

    _this.hasChanged = function (config, savedConfig) {
        var hasChanged = !angular.equals(_this.config, _this.savedConfig);
        return hasChanged;
    };

    _this.writingRegistry = function () {
        angular.forEach(_this.config.schedule, function (value, key) {
            jnrwebsocket.registryWrite(value.regname, value.output)
        })
        _this.savedConfig = angular.copy(_this.config);
        alert("Configuration Saved. A reboot may be needed for some changes to take affect.");
    };

}]);