/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.threading;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.threading.ThreadPool;
import com.integpg.system.JANOS;

public class ThreadWorker
extends Thread {
    private static final int THREADWORKER_TIMEOUT = 300000;
    private static int _threadCount = 1;
    private final int _index;
    private Runnable _task;
    private boolean _cancel = false;
    private boolean _done = false;

    public ThreadWorker(int index) {
        this._index = index;
        super.setDaemon(true);
        super.setName(String.format("%s-%d", this.getClass().getName(), _threadCount++));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTask(Runnable task) {
        ThreadWorker threadWorker = this;
        synchronized (threadWorker) {
            this._task = task;
            this.notifyAll();
            Thread.yield();
        }
    }

    public boolean isBusy() {
        return this._task != null;
    }

    public boolean isDone() {
        return this._done;
    }

    public void cancel() {
        this._cancel = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._cancel) {
            ThreadWorker threadWorker = this;
            synchronized (threadWorker) {
                block10: {
                    if (this._task == null) {
                        try {
                            long elapsedWait;
                            long beforeWaitTime = System.currentTimeMillis();
                            this.wait(300000L);
                            if (3 < ThreadPool.getWorkerCount() && 300000L <= (elapsedWait = System.currentTimeMillis() - beforeWaitTime)) {
                                this._done = true;
                                break;
                            }
                        }
                        catch (InterruptedException ex) {
                            if (this._cancel) break block10;
                            AppLog.error("Error executing ThreadWorker", ex);
                            JANOS.syslog((String)String.format("Error executing ThreadWorker: %s", ex.getMessage()), (int)3);
                        }
                    }
                }
            }
            if (this._task == null) continue;
            try {
                this._task.run();
            }
            catch (Exception ex) {
                AppLog.error("Error executing task in ThreadWorker", ex);
                JANOS.syslog((String)String.format("Error executing task in ThreadWorker: %s", ex.getMessage()), (int)3);
            }
            this._task = null;
            ThreadPool.threadWorkerAvailable(this);
        }
        ThreadPool.LOG.info(this.getName() + " is done.");
        AppLog.info(this.getName() + " is done.");
        this._done = true;
    }
}

