/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.messaging;

import com.integpg.cinema.AssemblyInfo;
import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.messaging.CinemaSystemMessage;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.JANOS;
import java.util.Json;

public class SummaryResponseSystemMessage
extends CinemaSystemMessage {
    private static final Json Json = new Json();

    public SummaryResponseSystemMessage() {
        super("summary.response");
        long uptimeSeconds = JANOS.uptimeMillis() / 1000L;
        Json.put("UptimeSeconds", uptimeSeconds);
        long days = uptimeSeconds / 86400L;
        long hours = uptimeSeconds % 86400L / 3600L;
        long minutes = uptimeSeconds % 3600L / 60L;
        long seconds = uptimeSeconds % 60L;
        if (7L < days) {
            long weeks = days / 7L;
            Json.put("UptimeString", (Object)String.format("%lld weeks, %lld days %02lld:%02lld:%02lld", weeks, days %= 7L, hours, minutes, seconds));
        } else {
            Json.put("UptimeString", (Object)String.format("%lld days %02lld:%02lld:%02lld", days, hours, minutes, seconds));
        }
        CinemaMain.INSTANCE.cinemaServerClientComm.getServerPort();
        Json cinemaServerClientJson = new Json();
        cinemaServerClientJson.put("Port", CinemaMain.INSTANCE.cinemaServerClientComm.getServerPort());
        cinemaServerClientJson.put("SerialPort", (Object)CinemaMain.INSTANCE.cinemaServerClientComm.getSerialPort());
        Json.put("CinemaServerClient", (Object)cinemaServerClientJson);
        Json preshowClientJson = new Json();
        preshowClientJson.put("TcpPort", CinemaMain.INSTANCE.clientComm.getServerPort());
        preshowClientJson.put("SerialPort", (Object)CinemaMain.INSTANCE.clientComm.getSerialPort());
        Json.put("PreshowClient", (Object)preshowClientJson);
        this.put("Summary", Json);
    }

    @Override
    public SummaryResponseSystemMessage build() {
        super.build();
        return this;
    }

    static {
        Json.put("Hostname", (Object)UnitConfig.getHostname());
        Json.put("IpAddress", (Object)UnitConfig.getIpAddress());
        Json.put("Model", (Object)UnitConfig.MODEL);
        Json.put("SerialNumber", UnitConfig.SERIAL_NUMBER);
        Json.put("JANOSVersion", (Object)UnitConfig.VERSION);
        Json.put("CinemaVersion", (Object)AssemblyInfo.getInstance().getVersion());
    }
}

