/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.xchange;

import com.integpg.janoslib.system.UnitConfig;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import com.integpg.xchange.XChangeListener;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Json;
import java.util.Vector;

public class XChangeConnection {
    public static byte[] MACRO_NAMES = "MACRO_NAMES".getBytes();
    public static byte[] CR_LF = "\r\n".getBytes();
    private static XChangeConnection INSTANCE;
    private Socket _socket;
    private long _lastWrite = JANOS.uptimeMillis();
    private String _host;
    private Hashtable _savedCommands = new Hashtable();
    private Vector _listeners = new Vector();

    private XChangeConnection() {
    }

    public static XChangeConnection getInstance() {
        if (INSTANCE == null) {
            System.out.println("xchange connection");
            INSTANCE = new XChangeConnection();
            INSTANCE.init();
        }
        return INSTANCE;
    }

    public void setHost(String host) {
        System.out.println("Set XChange host: " + host);
        this._host = host;
    }

    public void addListener(XChangeListener listener) {
        this._listeners.addElement(listener);
    }

    private void init() {
        Thread thd = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean exceptionShown = false;
                    while (true) {
                        try {
                            if (XChangeConnection.this._socket == null && XChangeConnection.this._host != null && !XChangeConnection.this._host.equals("") && !XChangeConnection.this._host.equals("none")) {
                                System.out.println("Connecting to Cinema Manager @ " + XChangeConnection.this._host);
                                XChangeConnection.this._socket = new Socket(XChangeConnection.this._host, 9100);
                                exceptionShown = false;
                                FileLogger.info("Connected to XChange server: " + XChangeConnection.this._host);
                                XChangeConnection.this.handleConnection();
                            }
                        }
                        catch (UnknownHostException ex) {
                            ex.printStackTrace();
                            if (!exceptionShown) {
                                XChangeConnection.this.exceptionThrown(ex);
                            }
                            exceptionShown = true;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            if (!exceptionShown) {
                                FileLogger.error("Unable to connect to XChange server: " + XChangeConnection.this._host);
                            }
                            exceptionShown = true;
                        }
                        try {
                            Thread.sleep(20000L);
                        }
                        catch (InterruptedException ex) {
                            XChangeConnection.this.exceptionThrown(ex);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
        }, "Establish CM Connection");
        thd.setDaemon(true);
        thd.start();
    }

    private void handleConnection() {
        Thread thd = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Client Connected");
                    XChangeConnection.this._socket.setSoTimeout(10000);
                    if (XChangeConnection.this._listeners != null && XChangeConnection.this._listeners.size() > 0) {
                        for (int i = 0; i < XChangeConnection.this._listeners.size(); ++i) {
                            ((XChangeListener)XChangeConnection.this._listeners.elementAt(i)).clientConnected();
                        }
                    }
                    DataInputStream dis = null;
                    byte[] bytes = new byte[1024];
                    while (XChangeConnection.this._socket != null) {
                        block23: {
                            if (dis == null) {
                                dis = new DataInputStream(XChangeConnection.this._socket.getInputStream());
                            }
                            try {
                                byte c = dis.readByte();
                                if (c != 1) continue;
                                short bytesToRead = dis.readShort();
                                if (bytesToRead < 0) {
                                    throw new IOException("Client closing connection");
                                }
                                dis.readFully(bytes, 0, bytesToRead);
                                byte commandLength = bytes[0];
                                String command = new String(bytes, 1, (int)commandLength);
                                byte payloadLength = bytes[commandLength + 1];
                                String payload = new String(bytes, commandLength + 2, (int)payloadLength);
                                System.out.println("Command Recv'd: " + command + " " + payloadLength + " " + payload);
                                if (command.equalsIgnoreCase("json")) {
                                    Json json = new Json(payload);
                                    String source = (String)json.get("source");
                                    if (command.equalsIgnoreCase("GET_COMMANDS")) {
                                        XChangeConnection.this.sendKnownStatuses(source);
                                    } else if (XChangeConnection.this._listeners != null && XChangeConnection.this._listeners.size() > 0) {
                                        for (int i = 0; i < XChangeConnection.this._listeners.size(); ++i) {
                                            ((XChangeListener)XChangeConnection.this._listeners.elementAt(i)).clientMessageReceived(json);
                                        }
                                    }
                                }
                            }
                            catch (InterruptedIOException ex) {
                                if (JANOS.uptimeMillis() - XChangeConnection.this._lastWrite <= 10000L) break block23;
                                try {
                                    XChangeConnection.this._socket.getOutputStream().write(CR_LF);
                                    XChangeConnection.this._lastWrite = JANOS.uptimeMillis();
                                }
                                catch (Exception ex1) {
                                    XChangeConnection.this._socket.close();
                                    XChangeConnection.this._socket = null;
                                }
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            XChangeConnection.this.exceptionThrown(e);
                        }
                    }
                }
                catch (EOFException ex) {
                    FileLogger.error("XChange server disconnected");
                }
                catch (IOException ex) {
                    FileLogger.error("XChange server disconnected: IOException");
                }
                catch (Exception ex) {
                    XChangeConnection.this.exceptionThrown(ex);
                }
                try {
                    System.out.println("Client disconnected");
                    if (XChangeConnection.this._socket != null) {
                        XChangeConnection.this._socket.close();
                        XChangeConnection.this._socket = null;
                    }
                }
                catch (Exception ex) {
                    XChangeConnection.this.exceptionThrown(ex);
                }
            }
        }, "Handle CM Connection");
        thd.setDaemon(true);
        thd.start();
    }

    public void sendKnownStatuses(String requester) {
        System.out.println("get known statuses");
        StringBuffer sb = new StringBuffer();
        Enumeration e = this._savedCommands.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this._savedCommands.get(key);
            System.out.println(key + " = " + value);
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(key);
            sb.append('=');
            sb.append(value);
        }
        System.out.println("known statuses: " + sb.toString());
        if (sb.length() > 0) {
            this.send(String.valueOf(UnitConfig.SERIAL_NUMBER), "status", sb.toString(), requester);
        }
    }

    public void send(String source, String command, String value) {
        this.send(source, command, value, null);
    }

    public synchronized void send(String source, String command, String value, String destination) {
        int equalPos;
        System.out.println(command + ", " + value);
        if (command.equalsIgnoreCase("update") && (equalPos = value.indexOf(61)) > 0) {
            this._savedCommands.put(value.substring(0, equalPos).trim(), value.substring(equalPos + 1).trim());
        }
        Json json = new Json();
        json.put("source", (Object)source);
        json.put("command", (Object)command);
        json.put("value", (Object)value);
        if (destination != null) {
            json.put("dest", (Object)destination);
        }
        try {
            if (this._socket != null) {
                this._socket.getOutputStream().write(json.toString().getBytes());
                this._socket.getOutputStream().write(CR_LF);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            try {
                this._socket.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            this._socket = null;
        }
    }

    private void exceptionThrown(Exception ex) {
        if (this._listeners != null && this._listeners.size() > 0) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((XChangeListener)this._listeners.elementAt(i)).exceptionThrown(ex);
            }
        }
    }
}

