/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.barco.pulse.api.Authenticate;
import com.barco.pulse.api.AuthenticationReceivedEvent;
import com.barco.pulse.api.DowserCommand;
import com.barco.pulse.api.MacroExecute;
import com.barco.pulse.api.PulseApiConnection;
import com.barco.pulse.api.PulseApiConnectionListener;
import com.barco.pulse.api.SystemPowerCommand;
import com.barco.pulse.api.SystemPowerOff;
import com.barco.pulse.api.SystemPowerOn;
import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.net.BytesReceivedEvent;
import com.integpg.janoslib.net.MessageReceivedEvent;
import com.integpg.logger.FileLogger;
import java.util.EventObject;
import java.util.Json;

public class BarcoSeries4
extends TheatreEthernetDevice
implements PulseApiConnectionListener {
    private PulseApiConnection _projector;

    public BarcoSeries4(String name) {
        super(name);
        this._port = "43731";
        FileLogger.info(Config.DEVICES_LOG, "Projector is " + name);
        this._projector = new PulseApiConnection();
        this._projector.addConnectionListener(this);
    }

    @Override
    public void setPort(String port) {
        super.setPort(port);
    }

    @Override
    public synchronized boolean sendNamedCommand(String commandName) {
        System.out.println(this.name + " Barco series 4 macro: " + commandName);
        Json response = null;
        if (!this.ensureConnection()) {
            FileLogger.warn(Config.DEVICES_LOG, "could not connect to " + this.name);
            return false;
        }
        if (commandName.toLowerCase().equals("power on")) {
            try {
                response = this._projector.request(new SystemPowerOn());
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, String.format("error powering on %s", this.name));
            }
        } else if (commandName.toLowerCase().equals("power off")) {
            try {
                response = this._projector.request(new SystemPowerOff());
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, String.format("error powering off %s", this.name));
            }
        } else if (commandName.toLowerCase().equals("close dowser")) {
            try {
                response = this._projector.request(new DowserCommand(false));
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, String.format("error closing %s dowser", this.name));
            }
        } else if (commandName.toLowerCase().equals("open dowser")) {
            try {
                response = this._projector.request(new DowserCommand(true));
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, String.format("error opening %s dowser", this.name));
            }
        } else if (commandName.toLowerCase().equals("lamp on")) {
            try {
                response = this._projector.request(new SystemPowerCommand().powerOn());
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, String.format("error turning %s lamp on", this.name));
            }
        } else if (commandName.toLowerCase().equals("lamp off")) {
            try {
                response = this._projector.request(new SystemPowerCommand().powerReady());
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, String.format("error turning %s lamp off", this.name));
            }
        } else if (commandName.toLowerCase().startsWith("send")) {
            String customCommand = commandName.substring(5);
            System.out.println("customCommand: " + customCommand);
        } else {
            try {
                response = this._projector.request(new MacroExecute(commandName));
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, String.format("error turning %s lamp off", this.name));
            }
        }
        System.out.println("response = " + response);
        return response != null;
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public boolean ensureConnection() {
        System.out.println("_projector.isConnected() = " + this._projector.isConnected());
        if (!this._projector.isConnected()) {
            try {
                this._projector.setHost(this._host);
                this._projector.setPort(Integer.valueOf(this._port));
                System.out.println("_projector.connect()");
                this._projector.connect();
            }
            catch (Throwable ex) {
                FileLogger.error(Config.DEVICES_LOG);
            }
        }
        return this._projector.isConnected();
    }

    @Override
    public void connectionAttempt(EventObject evt) {
        PulseApiConnection connection = (PulseApiConnection)evt.getSource();
        connection.setHost(this._host);
        FileLogger.info(String.format("Attempting connection to %s", connection.getConnectionInfo()));
    }

    @Override
    public void connectionEstablished(EventObject evt) {
        PulseApiConnection connection = (PulseApiConnection)evt.getSource();
        FileLogger.info(String.format("Connection established to %s", connection.getConnectionInfo()));
        Json response = connection.request(new Authenticate("admin", "Admin1234"));
        FileLogger.info(String.format("auth response: %s", response.toString()));
        if (response.getBoolean("result")) {
            FileLogger.info("connection authenticated");
        } else {
            FileLogger.info("connection authentication failed");
            connection.close();
        }
    }

    @Override
    public void connectionClosed(EventObject evt) {
        PulseApiConnection connection = (PulseApiConnection)evt.getSource();
        FileLogger.info(String.format("Connection lost from %s", connection.getConnectionInfo()));
        while (true) {
            try {
                Thread.sleep(10000L);
                connection.connect();
            }
            catch (Throwable ex) {
                FileLogger.error(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void bytesReceived(BytesReceivedEvent evt) {
        try {
            String asciiData = new String(evt.getBytes(), evt.getOffset(), evt.getLength());
            MessageReceivedEvent mre = new MessageReceivedEvent(evt.getSource(), asciiData);
            this.messageReceived(mre);
        }
        catch (Exception ex) {
            FileLogger.error("error processing read bytes", ex);
        }
    }

    public void messageReceived(MessageReceivedEvent evt) {
        String jsonString = (String)evt.getMessage();
        Json json = new Json(jsonString);
        FileLogger.info(String.format("messageReceived: %s", json.toString()));
        if (json.containsKey("method")) {
            this.processMethod(json);
        }
    }

    @Override
    public void authenticationReceived(AuthenticationReceivedEvent evt) {
    }

    private void processMethod(Json json) {
        String methodString = json.getString("method");
        FileLogger.info(String.format("   method: %s", methodString));
        Json paramsJson = null;
        if (json.containsKey("params")) {
            paramsJson = (Json)json.get("params");
            FileLogger.info(String.format("   params: %s", paramsJson.toString()));
        }
        switch (methodString) {
            case "property.changed": {
                Json[] properties;
                for (Json propertyJson : properties = (Json[])paramsJson.get("property")) {
                    String name = propertyJson.keyarray()[0];
                    System.out.println("      " + name + " = " + propertyJson.getString(name));
                }
                break;
            }
        }
    }
}

