/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messagepump;

import com.integpg.janoslib.collections.BlockingQueue;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.messagepump.MessagePumpListener;
import com.integpg.janoslib.messagepump.SystemMsgTypes;
import com.integpg.system.MessagePump;
import com.integpg.system.SystemMsg;
import java.util.ArrayList;

public class MessagePumpEngine {
    private static Logger DEBUG_LOG = null;
    private static final MessagePumpEngine INSTANCE = new MessagePumpEngine();
    private static boolean PumpOpen = false;
    private static Logger LOG = null;
    private final MessagePump MESSAGE_PUMP = new MessagePump();
    private final BlockingQueue<SystemMsg> BLOCKING_QUEUE = new BlockingQueue();
    private final ArrayList<MessagePumpListener> LISTENERS = new ArrayList();
    private Thread _messagePumpProducerThread;
    private Thread _messagePumpConsumerThread;

    private MessagePumpEngine() {
        this.BLOCKING_QUEUE.setName("MessagePumpEngineQueue");
        DEBUG_LOG = Logger.getLogger("temp/MessagePumpEngine.log");
    }

    public static void setLog(Logger log) {
        LOG = log;
    }

    public static Logger getLog() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(MessagePumpListener listener) {
        ArrayList<MessagePumpListener> arrayList = MessagePumpEngine.INSTANCE.LISTENERS;
        synchronized (arrayList) {
            MessagePumpEngine.INSTANCE.LISTENERS.add(listener);
        }
        if (!PumpOpen) {
            MessagePumpEngine.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        if (PumpOpen) {
            return;
        }
        MessagePumpEngine messagePumpEngine = INSTANCE;
        synchronized (messagePumpEngine) {
            INSTANCE.startProducer();
            INSTANCE.startConsumer();
        }
    }

    private void startProducer() {
        if (null == this._messagePumpProducerThread) {
            System.out.println("start message pump producer");
            this._messagePumpProducerThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MessagePumpEngine.this.openPump();
                    while (true) {
                        SystemMsg systemMsg = MessagePumpEngine.this.MESSAGE_PUMP.getMessage();
                        MessagePumpEngine.this.MESSAGE_PUMP.postMessage(systemMsg);
                        try {
                            MessagePumpEngine.this.BLOCKING_QUEUE.put(systemMsg);
                            int blockingQueueSize = MessagePumpEngine.this.BLOCKING_QUEUE.size();
                            if (5 <= blockingQueueSize) {
                                if (null == LOG) {
                                    LOG = DEBUG_LOG;
                                    AppLog.warn("message pump queue growth issue");
                                }
                                if (null != LOG) {
                                    Logger logger = LOG;
                                    synchronized (logger) {
                                        LOG.info(String.format("++ %d messages in the message queue", blockingQueueSize));
                                        String s = String.format("++ %s", SystemMsgTypes.getMessageInfo(systemMsg));
                                        LOG.info(s);
                                    }
                                }
                            }
                            Thread.sleep(10L);
                            continue;
                        }
                        catch (Exception ex) {
                            AppLog.error("error in message pump producer", ex);
                            continue;
                        }
                        break;
                    }
                }
            });
            this._messagePumpProducerThread.setName(MessagePumpEngine.class.getName() + ":queue");
            this._messagePumpProducerThread.setDaemon(true);
            this._messagePumpProducerThread.start();
        }
    }

    private void startConsumer() {
        if (null == this._messagePumpConsumerThread) {
            System.out.println("start message pump consumer");
            this._messagePumpConsumerThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Object object;
                                int blockingQueueSize;
                                SystemMsg systemMsg;
                                block16: {
                                    systemMsg = (SystemMsg)MessagePumpEngine.this.BLOCKING_QUEUE.get();
                                    blockingQueueSize = MessagePumpEngine.this.BLOCKING_QUEUE.size();
                                    try {
                                        if (null == LOG) break block16;
                                        object = LOG;
                                        synchronized (object) {
                                            LOG.info(String.format("-- %d messages in the message queue", blockingQueueSize));
                                            String s = String.format("-- %s", SystemMsgTypes.getMessageInfo(systemMsg));
                                            LOG.info(s);
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                if (0 == blockingQueueSize && null != LOG && null != LOG) {
                                    LOG = null;
                                }
                                object = MessagePumpEngine.this.LISTENERS;
                                synchronized (object) {
                                    for (int i = 0; i < MessagePumpEngine.this.LISTENERS.size(); ++i) {
                                        MessagePumpListener listener = (MessagePumpListener)MessagePumpEngine.this.LISTENERS.get(i);
                                        try {
                                            listener.messageReceived(systemMsg);
                                            continue;
                                        }
                                        catch (Throwable ex) {
                                            AppLog.error("error in message pump listener", ex);
                                        }
                                    }
                                }
                                Thread.sleep(1L);
                            }
                        }
                        catch (Exception ex) {
                            AppLog.error("error in message pump consumer", ex);
                            continue;
                        }
                        break;
                    }
                }
            });
            this._messagePumpConsumerThread.setName(MessagePumpEngine.class.getName() + ":notifier");
            this._messagePumpConsumerThread.setDaemon(true);
            this._messagePumpConsumerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postMessage(SystemMsg msg) {
        MessagePumpEngine messagePumpEngine = INSTANCE;
        synchronized (messagePumpEngine) {
            if (!PumpOpen) {
                MessagePumpEngine.start();
            }
            MessagePumpEngine.INSTANCE.MESSAGE_PUMP.postMessage(msg);
        }
    }

    private void openPump() {
        System.out.println("open the message pump and start monitoring.\r\n");
        this.MESSAGE_PUMP.open();
        PumpOpen = true;
    }
}

