/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.webhandlers;

import com.integpg.cinema.webhandlers.ExternalDeviceJson;
import com.integpg.cinema.webhandlers.InternalIoJson;
import com.integpg.janoslib.net.http.server.HttpContext;
import com.integpg.janoslib.net.http.server.HttpResponse;
import com.integpg.janoslib.net.http.server.WebHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Json;

public class GetDeviceWebHandler
implements WebHandler {
    private PrintWriter _out;

    @Override
    public void processRequest(HttpContext httpContext) {
        try {
            System.out.println(String.format("%lld GetWebHandler request received", System.currentTimeMillis()));
            HttpResponse response = httpContext.getResponse();
            response.setContentType("application/json");
            this._out = response.getWriter();
            Hashtable<String, String> queryParams = httpContext.getRequest().getQueryParams();
            try {
                Json json = null;
                String deviceType = queryParams.get("device");
                if (null != deviceType) {
                    ExternalDeviceJson externalDeviceJson = new ExternalDeviceJson(deviceType);
                    json = externalDeviceJson.getJson();
                } else {
                    InternalIoJson internalIoJson = new InternalIoJson();
                    json = internalIoJson.getJson();
                }
                this._out.println(json.toString());
            }
            catch (Exception ex) {
                this._out.println("error: " + ex.getMessage());
                ex.printStackTrace();
            }
            System.out.println(String.format("%lld GetDeviceWebHandler request done", System.currentTimeMillis()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                httpContext.getRequest().close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }
}

