/*
 * Decompiled with CFR 0.152.
 */
package com.barco.pulse.api;

import com.barco.pulse.api.ConnectionListenerNotifier;
import com.barco.pulse.api.JsonRpcCommand;
import com.barco.pulse.api.NotConnectedException;
import com.barco.pulse.api.PulseApiConnectionListener;
import com.barco.pulse.api.UnableToConnectException;
import com.barco.pulse.json.JsonStream;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.net.BytesReceivedEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Json;

public class PulseApiConnection
implements Runnable {
    private static final Logger LOG = Logger.getLogger("/barco_pulseApi_protocol.log");
    private static final Logger ERROR_LOG = Logger.getLogger("/barco_pulseApi_error.log");
    private Socket _client = null;
    private String _host = null;
    private int _port = 43731;
    private String _connectionInfomationString = null;
    private final ByteArrayOutputStream _baosOut = new ByteArrayOutputStream();
    private final DataOutputStream _dataOut = new DataOutputStream(this._baosOut);
    private DataInputStream _dataIn = null;
    private Thread _thread = null;
    private final ConnectionListenerNotifier _connectionListenerNotifier = new ConnectionListenerNotifier();
    private final JsonStream _jsonStream = new JsonStream();
    private final Hashtable<Integer, JsonRpcCommand> _commandsSentById = new Hashtable();
    private Json _response = null;
    private Hashtable<Integer, Object> _responseLocksById = new Hashtable();
    private Object _responseLock = new Object();

    public PulseApiConnection() {
        Thread thd = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Json json;
                            if (null == (json = PulseApiConnection.this._jsonStream.getNextJson())) {
                                continue;
                            }
                            LOG.info(String.format("  --> %s", json.toString()));
                            if (json.containsKey("id")) {
                                int id = json.getInt("id");
                                Object responseLock = PulseApiConnection.this._responseLock;
                                if (PulseApiConnection.this._responseLocksById.containsKey(id)) {
                                    responseLock = PulseApiConnection.this._responseLocksById.remove(id);
                                }
                                Object object = responseLock;
                                synchronized (object) {
                                    if (PulseApiConnection.this._commandsSentById.containsKey(id)) {
                                        JsonRpcCommand jsonRpcCommand = (JsonRpcCommand)PulseApiConnection.this._commandsSentById.get(id);
                                        PulseApiConnection.this._response = json;
                                        responseLock.notifyAll();
                                    }
                                }
                            }
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    String jsonString = json.toString();
                                    PulseApiConnection.this._connectionListenerNotifier.notifyBytesReceived(new BytesReceivedEvent(PulseApiConnection.this, jsonString.getBytes(), 0, jsonString.length()));
                                }
                            }).start();
                        }
                    }
                    catch (Exception ex) {
                        ERROR_LOG.error(ex);
                        continue;
                    }
                    break;
                }
            }
        });
        thd.setName(PulseApiConnection.class.getName() + "-processor");
        thd.setDaemon(true);
        thd.start();
    }

    public PulseApiConnection setHost(String host) {
        this._host = host;
        return this;
    }

    public PulseApiConnection setPort(int port) {
        this._port = port;
        return this;
    }

    public String getConnectionInfo() {
        return this._connectionInfomationString;
    }

    public void addConnectionListener(PulseApiConnectionListener listener) {
        this._connectionListenerNotifier.addConnectionListener(listener);
    }

    public boolean isConnected() {
        return null != this._client;
    }

    public synchronized void connect() throws Throwable {
        try {
            if (null == this._client) {
                if (null == this._host) {
                    throw new RuntimeException("Host is not yet set");
                }
                this._connectionInfomationString = String.format("%s:%d", this._host, this._port);
                LOG.info(String.format("connect to %s:%d", this._host, this._port));
                this._connectionListenerNotifier.notifyConnectionAttempt(new EventObject(this));
                this._client = new Socket(this._host, this._port);
                this._connectionInfomationString = String.format("%s:%d using local %d", this._host, this._client.getPort(), this._client.getLocalPort());
                LOG.info(String.format("connected to %s", this._connectionInfomationString));
                this._dataIn = new DataInputStream(this._client.getInputStream());
                this._thread = new Thread(this);
                this._thread.setName(this.getClass().getName());
                this._thread.setDaemon(true);
                this._thread.start();
                this._connectionListenerNotifier.notifyConnectionEstablished(new EventObject(this));
            }
        }
        catch (Exception ex) {
            this.close();
            throw new UnableToConnectException(this._host, this._port).initCause(ex);
        }
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean graceful) {
        try {
            if (null != this._client) {
                LOG.info(String.format("closing connection to %s", this._connectionInfomationString));
                this._client.close();
                this._connectionListenerNotifier.notifyConnectionClosed(new EventObject(this));
            }
        }
        catch (IOException ex) {
            ERROR_LOG.error("error closing socket", ex);
        }
        finally {
            this._client = null;
        }
    }

    @Override
    public void run() {
        byte[] buffer = new byte[1024];
        block4: while (true) {
            try {
                while (null != this._client) {
                    int bytesRead = this._dataIn.read(buffer);
                    if (-1 == bytesRead) {
                        throw new IOException();
                    }
                    try {
                        String asciiData = new String(buffer, 0, bytesRead);
                        LOG.info(String.format("<-- %d bytes: %s", bytesRead, asciiData));
                        this._jsonStream.append(asciiData);
                        continue block4;
                    }
                    catch (Exception ex) {
                        LOG.error("error processing read bytes", ex);
                    }
                }
                break;
            }
            catch (Exception ex) {
                this.close();
                ERROR_LOG.error("error in run()", ex);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JsonRpcCommand jsonRpcCommand) {
        if (null == this._client) {
            throw new NotConnectedException();
        }
        String jsonString = jsonRpcCommand.toString();
        this._commandsSentById.put(jsonRpcCommand.getId(), jsonRpcCommand);
        try {
            ByteArrayOutputStream byteArrayOutputStream = this._baosOut;
            synchronized (byteArrayOutputStream) {
                this._baosOut.reset();
                this._dataOut.write(jsonString.getBytes());
                byte[] outBytes = this._baosOut.toByteArray();
                LOG.info(String.format("<--   %s", jsonString));
                this._client.getOutputStream().write(outBytes);
                this._client.getOutputStream().flush();
            }
        }
        catch (Exception ex) {
            ERROR_LOG.error(String.format("error sending: %s" + jsonString, new Object[0]), ex);
            this.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Json request(JsonRpcCommand jsonRpcCommand) {
        this.send(jsonRpcCommand);
        Object responseLock = new Object();
        this._responseLocksById.put(jsonRpcCommand.getId(), responseLock);
        LOG.info("wait for lock: " + jsonRpcCommand);
        Object object = responseLock;
        synchronized (object) {
            LOG.info("acquired lock: " + jsonRpcCommand);
            try {
                responseLock.wait();
            }
            catch (InterruptedException ex) {
                ERROR_LOG.error(String.format("error blocking on sending %s", jsonRpcCommand.getJson().toString()), ex);
            }
            return this._response;
        }
    }
}

