/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.messaging;

import com.integpg.janoslib.messagepump.MessagePumpAppMessageListener;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.logger.FileLogger;
import java.io.IOException;
import java.net.Socket;
import java.util.Json;

public class DeviceTestEventHandler
implements MessagePumpAppMessageListener {
    private static Socket Socket = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applicationMessageReceived(Json commandJson) {
        FileLogger.info(String.format("%s received %s", this.getClass().getName(), commandJson.toString()));
        try {
            String ipAddress = commandJson.getString("IP");
            System.out.println("ipAddress = " + ipAddress);
            int port = commandJson.getInt("Port");
            System.out.println("port = " + port);
            String commandString = commandJson.getString("Command");
            System.out.println("commandString = " + commandString);
            byte[] commandBytes = StringUtils.getEscapedBytes(commandString);
            System.out.println(HexUtils.bytesToHex(commandBytes));
            Socket = new Socket(ipAddress, port);
            Socket.getOutputStream().write(commandBytes);
            Socket.getOutputStream().flush();
        }
        catch (Throwable ex) {
            FileLogger.error("error processing device test event handler", ex);
        }
        finally {
            if (null != Socket) {
                try {
                    Socket.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

