/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreDevice;
import com.integpg.logger.FileLogger;
import java.io.IOException;
import java.net.Socket;
import java.util.Date;

public abstract class TheatreEthernetDevice
extends TheatreDevice {
    protected Socket socket;

    public TheatreEthernetDevice(String name) {
        super(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean login() {
        return true;
    }

    @Override
    public boolean connect(String host, String port) {
        boolean success = true;
        System.out.println("connect to: " + host + " " + port);
        if (host == null || host.equals("")) {
            return false;
        }
        this._host = host;
        this._port = port;
        try {
            this.socket = new Socket(host, (int)Integer.valueOf(port));
            FileLogger.info(Config.DEVICES_LOG, this.name + " Connected to " + host + ":" + port + " local port: " + this.socket.getLocalPort());
        }
        catch (Exception ex) {
            this.socket = null;
            success = false;
            FileLogger.error(Config.DEVICES_LOG, this.name + " " + ex.getMessage());
            System.out.println(new Date().toString() + " " + ex.toString());
        }
        try {
            if (success && this.socket != null) {
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
                this.login();
            }
        }
        catch (IOException ex) {
            success = false;
            FileLogger.error(Config.DEVICES_LOG, this.name + " " + ex.getMessage());
            ex.printStackTrace();
        }
        if (!success) {
            if (!this.HAS_FAILED) {
                CinemaMain.INSTANCE.sendTrap("1.3.6.1.4.1.31976.2.0.3", this.name + " Could Not Connect to the Device");
                FileLogger.error(Config.DEVICES_LOG, this.name + " Could Not Connect to the Device");
            }
        } else if (this.HAS_FAILED) {
            CinemaMain.INSTANCE.sendTrap("1.3.6.1.4.1.31976.2.0.3", this.name + " Device Communication Restored");
            FileLogger.info(Config.DEVICES_LOG, this.name + " Device Communication Restored");
        }
        this.HAS_FAILED = !success;
        return success;
    }

    public boolean ensureConnection() {
        System.out.println("raw eth socket: " + this.socket);
        if (this.socket == null) {
            System.out.println("raw eth connect");
            return this.connect(this._host, this._port);
        }
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            FileLogger.error(Config.DEVICES_LOG, this.name + " " + ex.getMessage());
            return this.connect(this._host, this._port);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this.socket != null) {
            Socket socket = this.socket;
            synchronized (socket) {
                try {
                    this.socket.close();
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Disconnected");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    FileLogger.error(Config.DEVICES_LOG, this.name + " " + ex.getMessage());
                }
                this.socket = null;
                this.in = null;
                this.out = null;
            }
        }
    }
}

