/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.AssemblyInfo;
import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.client.JsonReceiver;
import com.integpg.cinema.client.JsonSender;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Json;
import java.util.Vector;

public class JsonClientHandler
implements Runnable,
MacroRequestListener {
    public static String JSON_SERVER_LOG = "jsonserver.log";
    private static final Vector<JsonClientHandler> CLIENT_HANDLERS = new Vector();
    private final Socket _socket;
    private final String _clientInfo;
    private boolean _quit = false;
    private final JsonReceiver _jsonRecevier;
    private final JsonSender _jsonSender;

    public JsonClientHandler(Socket socket) throws IOException {
        this._socket = socket;
        this._clientInfo = this._socket.getInetAddress().getHostAddress() + ":" + this._socket.getPort();
        this._jsonRecevier = new JsonReceiver(this._socket);
        this._jsonSender = new JsonSender(this._socket);
        CLIENT_HANDLERS.addElement(this);
    }

    @Override
    public void run() {
        FileLogger.info(JSON_SERVER_LOG, "Client Connected: " + this._clientInfo);
        try {
            while (!this._quit) {
                Json jsonMessage = this._jsonRecevier.getJson();
                if (jsonMessage != null) {
                    this.messageReceived(jsonMessage);
                    continue;
                }
                FileLogger.info(JSON_SERVER_LOG, "Client Disconnected");
                this._quit = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ExceptionHandler.logException(0, ex);
        }
        try {
            this._jsonRecevier.close();
            this._jsonSender.close();
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, ex);
        }
        FileLogger.info(JSON_SERVER_LOG, "Client Disconnected: " + this._clientInfo);
    }

    public boolean messageReceived(Json json) throws IOException {
        boolean result = false;
        FileLogger.info(JSON_SERVER_LOG, " <- " + json);
        String message = json.getString("Message");
        if ("GetInfo".equalsIgnoreCase(message)) {
            Json jsonResponse = new Json();
            jsonResponse.put("Message", (Object)"GetInfoResponse");
            jsonResponse.put("Information", (Object)("Cinema v" + AssemblyInfo.getVersion()));
            String hostname = JANOS.getRegistryString((String)"IpConfig/Hostname", (String)"");
            jsonResponse.put("Ident", (Object)hostname);
            this.send(jsonResponse);
        } else if ("GetMacroList".equalsIgnoreCase(message)) {
            this.sendMacroList();
        } else if ("RunMacro".equalsIgnoreCase(message)) {
            String macroName = json.getString("MacroName");
            MacroResult macroResult = CinemaMain.MacroFile.runMacro(this, macroName);
        } else if ("MacroAbort".equalsIgnoreCase(message)) {
            String macroName = json.getString("MacroName");
            Hashtable macroNames = CinemaMain.MacroFile.getMacroNames();
            Macro macro = (Macro)macroNames.get(macroName.toLowerCase());
            if (null != macro) {
                macro.abort();
                Json jsonResponse = new Json();
                jsonResponse.put("Message", (Object)"MacroAbortResponse");
                jsonResponse.put("Result", (Object)"Aborting");
                this.send(jsonResponse);
            } else {
                Json jsonResponse = new Json();
                jsonResponse.put("Message", (Object)"MacroAbortResponse");
                jsonResponse.put("Result", (Object)"Macro not found");
                this.send(jsonResponse);
            }
        }
        return result;
    }

    public static void updateMacroList() {
        for (int i = 0; i < CLIENT_HANDLERS.size(); ++i) {
            JsonClientHandler client = CLIENT_HANDLERS.elementAt(i);
            client.sendMacroList();
        }
    }

    private void sendMacroList() {
        try {
            Vector macroList = CinemaMain.MacroFile.getMacroNumbers();
            String[] macroArray = new String[macroList.size()];
            for (int i = 0; i < macroList.size(); ++i) {
                Macro macro = (Macro)macroList.elementAt(i);
                macroArray[i] = macro.getName();
            }
            Json jsonResponse = new Json();
            jsonResponse.put("Message", (Object)"GetMacroListResponse");
            jsonResponse.put("MacroList", (Object)macroArray);
            this.send(jsonResponse);
        }
        catch (IOException ex) {
            FileLogger.error(JSON_SERVER_LOG, ex.toString());
        }
    }

    public synchronized void send(Json json) throws IOException {
        FileLogger.info(JSON_SERVER_LOG, " -> " + json.toString());
        try {
            this._jsonSender.send(json);
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, ex);
            this._quit = true;
        }
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        try {
            Json jsonResponse = new Json();
            jsonResponse.put("Message", (Object)"MacroStatus");
            jsonResponse.put("Macro", (Object)macroResult.getMacro().getName());
            jsonResponse.put("Status", (Object)macroResult.getReason());
            jsonResponse.put("Running", (Object)macroResult.getResult());
            if (!macroResult.getResult()) {
                jsonResponse.put("Error", (Object)true);
            }
            this.send(jsonResponse);
        }
        catch (IOException ex) {
            FileLogger.error(JSON_SERVER_LOG, ex.toString());
        }
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
        try {
            Json jsonResponse = new Json();
            jsonResponse.put("Message", (Object)"MacroStatus");
            jsonResponse.put("Macro", (Object)macro.getName());
            jsonResponse.put("Status", (Object)updateString);
            jsonResponse.put("Running", (Object)running);
            this.send(jsonResponse);
        }
        catch (IOException ex) {
            FileLogger.error(JSON_SERVER_LOG, ex.toString());
        }
    }
}

