/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Logic;
import com.integpg.cinema.Monitor.IOStateListener;
import com.integpg.cinema.client.CinemaServerClient;
import com.integpg.cinema.client.ClientHandler;
import com.integpg.cinema.macro.InternalIOAction;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.system.JANOS;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CinemaServerClientHandler
implements Runnable,
IOStateListener,
MacroRequestListener {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff");
    private static final Pattern RUN_PATTERN = Pattern.compile("run ([\\w \\.\\-_\\(\\)]+)$", 1);
    private static final Pattern IO_CONTROL_PATTERN = Pattern.compile("::([copt\\+\\d\\*]+(=\\d+)?)$", 1);
    private static final Pattern DIN_QUERY_PATTERN = Pattern.compile("din(\\d+)\\?$", 1);
    private static final Pattern ROUT_QUERY_PATTERN = Pattern.compile("rout(\\d+)\\?$", 1);
    private boolean _quit = false;
    private static final String RUN = "run";
    private static String INVALID_COMMAND = "invalid_command";
    private CinemaServerClient m_parent = null;
    private InputStream m_inStream;
    private OutputStream m_outStream;
    private Socket m_socket;
    private String _clientInfo;
    private String _disconnectReason = "";
    private int _incommingByteArraySize = 1024;
    private byte[] _bytes = new byte[this._incommingByteArraySize];
    private int _offset = 0;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public CinemaServerClientHandler(CinemaServerClient parent) {
        this.m_parent = parent;
    }

    public CinemaServerClientHandler(CinemaServerClient parent, InputStream inputStream, OutputStream outputStream) {
        this(parent, inputStream, outputStream, null);
    }

    public CinemaServerClientHandler(CinemaServerClient parent, InputStream inputStream, OutputStream outputStream, Socket socket) {
        this.m_parent = parent;
        this.m_inStream = inputStream;
        this.m_outStream = outputStream;
        System.out.println("outstream: " + this.m_outStream);
        this.m_socket = socket;
        if (this.m_socket != null) {
            this._clientInfo = this.m_socket.getInetAddress().getHostAddress() + ":" + this.m_socket.getPort();
        } else {
            this._clientInfo = parent.CLIENT_METHOD;
            try {
                this.m_inStream.skip(this.m_inStream.available());
            }
            catch (IOException ex) {
                ExceptionHandler.logException(0, ex);
            }
        }
        if (this.m_parent.CLIENT_UNSOLICITED_IO) {
            int i;
            for (i = 1; i <= UnitConfig.getInputCount(); ++i) {
                CinemaMain.INSTANCE.m_stateMonitor.addStateListener(this, 0, i);
            }
            for (i = 1; i <= 16; ++i) {
                CinemaMain.INSTANCE.m_stateMonitor.addStateListener(this, 1, i);
            }
        }
    }

    @Override
    public void run() {
        CinemaServerClient.CINEMA_SERVER_LOG.info("Client Connected: " + this._clientInfo);
        ClientHandler ch = new ClientHandler(this.m_inStream, this.m_socket != null);
        ch.setTerminationBytes(this.m_parent.CLIENT_INCOMING_TERMINATION_BYTES);
        boolean quit = false;
        try {
            while (!quit) {
                String message = ch.getMessage();
                System.out.println("message = " + message);
                if (message != null) {
                    CinemaServerClient.CINEMA_SERVER_LOG.info("From Server: " + message);
                    this.execute(message);
                    continue;
                }
                CinemaServerClient.CINEMA_SERVER_LOG.info("Client Disconnected");
                quit = true;
            }
        }
        catch (Throwable ex) {
            ExceptionHandler.logException(0, ex);
            quit = true;
            this._disconnectReason = ex.getMessage();
        }
        try {
            if (this.m_inStream != null) {
                this.m_inStream.close();
                this.m_inStream = null;
            }
            if (this.m_outStream != null) {
                this.m_outStream.close();
                this.m_outStream = null;
            }
            if (this.m_socket != null) {
                this.m_socket.close();
                this.m_socket = null;
            }
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, ex);
        }
        if (this.m_parent.CLIENT_UNSOLICITED_IO) {
            for (int i = 1; i <= 16; ++i) {
                CinemaMain.INSTANCE.m_stateMonitor.removeStateListener(this, 0, i);
                CinemaMain.INSTANCE.m_stateMonitor.removeStateListener(this, 1, i);
            }
        }
        this._quit = true;
        CinemaServerClient.CINEMA_SERVER_LOG.info("Client Disconnected: " + this._clientInfo + " : " + this._disconnectReason);
        if (this.m_parent.m_tcpServer != null) {
            this.m_parent.m_tcpServer.remove(this);
        }
    }

    private Matcher getMatcherFor(Pattern pattern, String input) {
        Matcher matcher = pattern.matcher(input);
        return matcher;
    }

    public void execute(String line) throws IOException {
        System.out.println(line + " (" + line.length() + ")");
        Matcher matcher = this.getMatcherFor(IO_CONTROL_PATTERN, line);
        if (matcher.find()) {
            System.out.println("IO_CONTROL_PATTERN.groupCount(): " + matcher.groupCount());
            for (int i = 0; i < matcher.groupCount(); ++i) {
                System.out.println("  IO_CONTROL_PATTERN.group[" + i + "]: " + matcher.group(i));
            }
            if (1 < matcher.groupCount()) {
                InternalIOAction.parseCommand(matcher.group(1));
            }
        } else {
            matcher = this.getMatcherFor(DIN_QUERY_PATTERN, line);
            if (matcher.find()) {
                System.out.println("DIN_QUERY_PATTERN.groupCount(): " + matcher.groupCount());
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    System.out.println("  DIN_QUERY_PATTERN.group[" + i + "]: " + matcher.group(i));
                }
                int channelNumber = Integer.parseInt(matcher.group(1));
                int state = JANOS.getInputStates() >> channelNumber - 1 & 1;
                this.send("din" + channelNumber + "=" + state, true);
            } else {
                matcher = this.getMatcherFor(ROUT_QUERY_PATTERN, line);
                if (matcher.find()) {
                    System.out.println("ROUT_QUERY_PATTERN.groupCount(): " + matcher.groupCount());
                    for (int i = 0; i < matcher.groupCount(); ++i) {
                        System.out.println("  ROUT_QUERY_PATTERN.group[" + i + "]: " + matcher.group(i));
                    }
                    int channelNumber = Integer.parseInt(matcher.group(1));
                    int state = JANOS.getOutputStates() >> channelNumber - 1 & 1;
                    this.send("rout" + channelNumber + "=" + state, true);
                } else if (line.equalsIgnoreCase("pause")) {
                    try {
                        CinemaMain.INSTANCE.clientComm.pauseReceivedFromCinemaServer();
                        if (CinemaServerClient.PAUSE_DELAY > 0) {
                            Thread.sleep(CinemaServerClient.PAUSE_DELAY);
                        }
                    }
                    catch (InterruptedException ex) {
                        ExceptionHandler.logException(0, ex);
                    }
                    this.send("pause");
                } else if (CinemaServerClient._logicRulesByCommand.containsKey(line)) {
                    Logic logic = (Logic)CinemaServerClient._logicRulesByCommand.get(line);
                    int result = logic.evaluate(JANOS.getInputStates(), JANOS.getOutputStates());
                    if (result == 1) {
                        logic.execute();
                    }
                } else {
                    matcher = RUN_PATTERN.matcher(line);
                    boolean found = matcher.find();
                    System.out.println("RUN_PATTERN.find(): " + found);
                    if (found) {
                        System.out.println("matcher.groupCount(): " + matcher.groupCount());
                        for (int i = 0; i < matcher.groupCount(); ++i) {
                            System.out.println("  matcher.group[" + i + "]: " + matcher.group(i));
                        }
                        if (1 < matcher.groupCount()) {
                            this.send("executing_macro " + matcher.group(1), true);
                            System.out.println("executing_macro " + matcher.group(1));
                            boolean result = CinemaMain.MacroFile.runMacro(this, matcher.group(1).trim(), false).getResult();
                            if (!result) {
                                this.send(INVALID_COMMAND, false);
                            }
                        } else {
                            this.send(INVALID_COMMAND, false);
                        }
                    } else {
                        this.send(INVALID_COMMAND, false);
                    }
                }
            }
        }
    }

    public boolean commandReceived(String command, String params) throws IOException {
        boolean result = false;
        System.out.println("Command Received from client: " + command + " (" + params + ")");
        System.out.println(command + "=run ?" + command.equals(RUN));
        if (command.equals(RUN)) {
            this.send("executing_macro " + params, true);
            System.out.println("executing_macro " + params);
            result = CinemaMain.MacroFile.runMacro(this, params, false).getResult();
        }
        return result;
    }

    public synchronized void send(String s) throws IOException {
        this.send(s, true);
    }

    public synchronized void send(String s, boolean ack) {
        System.out.println("outstream: " + this.m_outStream);
        long ts = System.currentTimeMillis();
        try {
            this.baos.reset();
            if (this.m_parent.CLIENT_SEND_DATESTAMP) {
                this.baos.write(QUICK_DATE_FORMAT.format(ts).getBytes());
                this.baos.write(32);
            }
            if (this.m_parent.CLIENT_SEND_ACK) {
                if (ack) {
                    this.baos.write(43);
                } else {
                    this.baos.write(45);
                }
                this.baos.write(32);
            }
            this.baos.write(s.getBytes());
            this.baos.write(this.m_parent.CLIENT_OUTGOING_TERMINATION_BYTES);
            if (this.m_outStream != null) {
                this.m_outStream.write(this.baos.toByteArray());
                this.m_outStream.flush();
                CinemaServerClient.CINEMA_SERVER_LOG.info("  To Server: " + s);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            AppLog.error(ex);
            this._disconnectReason = s;
            this._quit = true;
        }
    }

    @Override
    public void ioStateChange(int io, byte channel, byte state, long inputStateMask, long outputStateMask) {
        try {
            if (io == 0) {
                if (this.m_parent.CLIENT_SEND_COUNTS) {
                    int count = JANOS.getInputCounter((int)(channel - 1));
                    this.send("IN" + channel + "=" + state + "," + count, true);
                } else {
                    this.send("IN" + channel + "=" + state, true);
                }
            } else {
                this.send("OUT" + channel + "=" + state, true);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.logException(0, ex);
            CinemaMain.INSTANCE.m_stateMonitor.removeStateListener(this, io, channel);
        }
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        this.send(macroResult.getReason(), macroResult.getResult());
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
    }
}

