/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integ.janoslib.externalmodules.DeviceInfo;
import com.integ.janoslib.externalmodules.EnvironSensor;
import com.integ.janoslib.externalmodules.ExternalDeviceMap;
import com.integ.janoslib.externalmodules.TempProbe;
import com.integpg.janoslib.http.server.HttpContext;
import com.integpg.janoslib.http.server.HttpResponse;
import com.integpg.janoslib.http.server.WebHandler;
import com.integpg.janoslib.io.AppLog;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Json;

public class GetDeviceWebHandler
implements WebHandler {
    private PrintWriter _out;

    @Override
    public void processRequest(HttpContext httpContext) {
        try {
            System.out.println(String.format("%lld GetDeviceWebHandler request received", System.currentTimeMillis()));
            AppLog.info(String.format("Processing %s", httpContext.getRequest().getRequestedURI()));
            HttpResponse response = httpContext.getResponse();
            response.setContentType("text/html");
            this._out = response.getWriter();
            Hashtable<String, String> queryParams = httpContext.getRequest().getQueryParams();
            try {
                String deviceType = queryParams.get("device");
                if (null == deviceType) {
                    throw new Exception("Device Name expected");
                }
                ExternalDeviceMap.update();
                DeviceInfo deviceInfo = ExternalDeviceMap.getByType(deviceType);
                if (null == deviceInfo) {
                    throw new Exception("Device Info is null");
                }
                deviceInfo.update();
                Json json = new Json();
                json.put("Address", (Object)deviceInfo.DeviceAddressString);
                if (deviceInfo instanceof TempProbe) {
                    TempProbe tempProbe = (TempProbe)deviceInfo;
                    json.put("Celsius", tempProbe.Celsius);
                    json.put("Fahrenheit", tempProbe.getFahrenheit(tempProbe.Celsius));
                } else if (deviceInfo instanceof EnvironSensor) {
                    EnvironSensor environSensor = (EnvironSensor)deviceInfo;
                    json.put("Celsius", environSensor.Celsius);
                    json.put("Fahrenheit", environSensor.getFahrenheit(environSensor.Celsius));
                    json.put("Humidity", environSensor.Humidity);
                }
                this._out.println(json.toString());
            }
            catch (Exception ex) {
                this._out.println("error: " + ex.getMessage());
                ex.printStackTrace();
            }
            System.out.println(String.format("%lld GetDeviceWebHandler request done", System.currentTimeMillis()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                httpContext.getRequest().close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }
}

