/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.externalmodules;

import com.integ.janoslib.beans.PropertyChangeEvent;
import com.integ.janoslib.beans.PropertyChangeListener;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import java.io.IOException;
import java.util.ArrayList;

public abstract class DeviceInfo {
    protected static final SensorPort SENSOR_PORT = new SensorPort();
    public final long DeviceAddress;
    public final String DeviceAddressString;
    public final int DeviceIndex;
    public byte[] DeviceBlock;
    public boolean Updated = false;
    public int FailureCount = 0;
    protected byte[] _savedBlock = null;
    protected int _significantDecimalPlaces = -1;
    protected String _precisionString = "%f";
    protected boolean _present = true;
    protected final ArrayList<PropertyChangeListener> _propertyChangeListeners = new ArrayList();

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null != propertyChangeListener) {
            this._propertyChangeListeners.add(propertyChangeListener);
        }
    }

    protected void alertPropertyChangeListeners(PropertyChangeEvent event) {
        if (0 != this._propertyChangeListeners.size()) {
            for (PropertyChangeListener listener : this._propertyChangeListeners) {
                listener.propertyChange(event);
            }
        }
    }

    public DeviceInfo(long deviceAddress, int index) {
        this.DeviceAddress = deviceAddress;
        String deviceAddressString = "0000000000000000" + Long.toHexString(deviceAddress);
        this.DeviceAddressString = deviceAddressString = deviceAddressString.substring(deviceAddressString.length() - 16);
        this.DeviceIndex = index;
    }

    public boolean isPresent() {
        return this._present;
    }

    public void setPresent(boolean present) {
        this._present = present;
    }

    public void setSignificantDecimalPlaces(int decimalPlaces) {
        this._significantDecimalPlaces = decimalPlaces;
        this._precisionString = "%." + decimalPlaces + "f";
    }

    public byte[] read() {
        byte[] deviceBlock;
        block5: {
            deviceBlock = null;
            this.Updated = false;
            if (this._present) {
                try {
                    deviceBlock = SensorPort.readDeviceBlock((long)this.DeviceAddress);
                    if (null == this._savedBlock) {
                        this._savedBlock = new byte[deviceBlock.length];
                    }
                    boolean bl = this.Updated = !ArrayUtils.arrayComp((Object)this._savedBlock, (int)0, (Object)deviceBlock, (int)0, (int)deviceBlock.length);
                    if (this.Updated) {
                        ArrayUtils.arraycopy((Object)deviceBlock, (int)0, (Object)this._savedBlock, (int)0, (int)deviceBlock.length);
                        this.DeviceBlock = deviceBlock;
                    }
                    this.FailureCount = 0;
                }
                catch (IOException ex) {
                    ++this.FailureCount;
                    System.out.println(String.format("could not read %s device: %s %d times", this.DeviceAddressString, ex.getMessage(), this.FailureCount));
                    if (3 > this.FailureCount) break block5;
                    this._present = false;
                }
            }
        }
        return deviceBlock;
    }

    public abstract void update();
}

