/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.http.server;

import com.integpg.janoslib.http.server.HttpContext;
import com.integpg.janoslib.http.server.HttpListener;
import com.integpg.janoslib.http.server.HttpRequest;
import com.integpg.janoslib.http.server.HttpServer;
import com.integpg.janoslib.http.server.WebHandler;
import com.integpg.janoslib.io.AppLog;
import java.util.Hashtable;

public class WebHandlerServer
implements HttpListener {
    private Hashtable<String, WebHandler> _webHandlers = new Hashtable();
    private HttpServer _httpServer;

    public void addWebHandler(String resource, WebHandler webHandler) {
        this._webHandlers.put(resource, webHandler);
    }

    public void start(int port) {
        this._httpServer = new HttpServer(port);
        this._httpServer.addListener(this);
        this._httpServer.start();
        AppLog.info("WebServer started on port " + port);
    }

    @Override
    public void requestRecieved(HttpRequest httpRequest) {
        try {
            System.out.println(String.format("%lld web handler request received", System.currentTimeMillis()));
            HttpContext httpContext = new HttpContext(httpRequest);
            String requestedResource = httpRequest.getRequestedResource();
            if (null == requestedResource) {
                requestedResource = "";
            }
            if (this._webHandlers.containsKey(httpRequest.getRequestedResource())) {
                try {
                    WebHandler webHandler = this._webHandlers.get(httpRequest.getRequestedResource());
                    webHandler.processRequest(httpContext);
                    httpContext.getResponse().sendResponse(200);
                }
                catch (Exception ex) {
                    ex.printStackTrace(httpContext.getResponse().getWriter());
                    httpContext.getResponse().sendResponse(500);
                }
            } else {
                this._httpServer.log("unknown resource: " + httpRequest.getRequestedURI());
                httpContext.getResponse().sendResponse(404);
                httpRequest.close();
            }
            httpRequest.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

