/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.macro;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integpg.cinema.MacroConfiguration;
import com.integpg.cinema.Rebooter;
import com.integpg.cinema.XChangeDevice;
import com.integpg.cinema.client.JsonClientHandler;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.cinema.messaging.MacroListResponseSystemMessage;
import com.integpg.janoslib.debug.Stopwatch;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.logger.FileLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class MacroFile
implements MacroRequestListener {
    private String _macroFile = null;
    private Hashtable _macroNames = new Hashtable();
    private Vector _macroNumbers = new Vector();
    private long _lastMacroFileModification;
    private Stopwatch _stopwatch = new Stopwatch("macro file", 200);
    private static final Object Lock = new Object();
    private boolean _loadingMacroFile;
    private boolean _macroInProgress;
    private Vector _macrosInProgress = new Vector();

    public Hashtable getMacroNames() {
        return this._macroNames;
    }

    public Vector getMacroNumbers() {
        return this._macroNumbers;
    }

    public String getMacroFile() {
        return this._macroFile;
    }

    public long getLastModified() {
        return this._lastMacroFileModification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadMacroFile(String macroFile) throws FileNotFoundException, IOException {
        if (macroFile == null) {
            return;
        }
        Object object = Lock;
        synchronized (object) {
            if (this._macroInProgress) {
                try {
                    Lock.wait();
                }
                catch (InterruptedException ex) {
                    AppLog.error("Error locking macro lock while macro in progress", ex);
                }
            }
            this._loadingMacroFile = true;
        }
        this._stopwatch.start();
        FileLogger.info("Loading Macro File " + macroFile);
        this._macroNames = new Hashtable();
        this._macroNumbers = new Vector();
        this._stopwatch.split("new macronames and macro numbers");
        int DEVICES = 1;
        int ACTIONS = 2;
        int DATA = 3;
        int MACROS = 4;
        BufferedReader br = new BufferedReader(new FileReader(new File(macroFile)));
        this._stopwatch.split("new buffered reader");
        int state = 0;
        int commandsLength = 200;
        String[] commands = new String[commandsLength];
        for (int i = 0; i < commandsLength; ++i) {
            commands[i] = "";
        }
        int devicesLength = 200;
        String[] devices = new String[devicesLength];
        for (int i = 0; i < devicesLength; ++i) {
            devices[i] = "";
        }
        int actionsLength = 200;
        String[] actions = new String[actionsLength];
        for (int i = 0; i < actionsLength; ++i) {
            actions[i] = "";
        }
        int dataLength = 200;
        String[] data = new String[dataLength];
        for (int i = 0; i < dataLength; ++i) {
            data[i] = "";
        }
        this._stopwatch.split("new arrays, initialized with empty strings");
        Macro macro = null;
        String macroName = null;
        int macroCount = 0;
        int lineCount = 1;
        block30: while (true) {
            String s;
            StringTokenizer st;
            int col;
            block62: {
                String line;
                if ((line = br.readLine()) == null) {
                    br.close();
                    this._stopwatch.stop();
                    FileLogger.info("Macro File Loaded");
                    XChangeDevice.getInstance().sendMacros(null);
                    this._lastMacroFileModification = new File(macroFile).lastModified();
                    this._macroFile = macroFile;
                    System.out.println("Time spent adding " + Macro.TotalActions + " actions " + Macro.TotalTime);
                    JsonClientHandler.updateMacroList();
                    Object ex = Lock;
                    synchronized (ex) {
                        this._loadingMacroFile = false;
                        Lock.notifyAll();
                    }
                    MacroListResponseSystemMessage systemMsg = new MacroListResponseSystemMessage().build();
                    MessagePumpEngine.postMessage(systemMsg);
                    return;
                }
                try {
                    this._stopwatch.split("line " + lineCount++);
                    if (state == 0 && !line.startsWith("Device")) continue;
                    col = 0;
                    st = new StringTokenizer(line, ",", true);
                    try {
                        s = st.nextToken();
                        break block62;
                    }
                    catch (NoSuchElementException ex) {
                        ExceptionHandler.logException(0, ex);
                    }
                }
                catch (Exception ex) {
                    AppLog.error(ex);
                }
                continue;
            }
            while (true) {
                if (s.equals(",") && st.hasMoreTokens()) {
                    try {
                        s = st.nextToken();
                    }
                    catch (NoSuchElementException ex) {
                        ExceptionHandler.logException(11, "Error loading macro file", ex);
                        return;
                    }
                    ++col;
                    continue;
                }
                if (s.equals(",")) continue block30;
                if (col == 0) {
                    if (col == 0 && s.equalsIgnoreCase("data")) {
                        state = DATA;
                        try {
                            s = st.nextToken();
                        }
                        catch (NoSuchElementException ex) {
                            ExceptionHandler.logException(12, "Error loading macro file", ex);
                            return;
                        }
                    }
                    if (col == 0 && s.equalsIgnoreCase("macro name")) {
                        break;
                    }
                    if (col == 0 && s.equalsIgnoreCase("device")) {
                        state = DEVICES;
                        try {
                            s = st.nextToken();
                        }
                        catch (NoSuchElementException ex) {
                            ExceptionHandler.logException(15, "Error loading macro file", ex);
                            return;
                        }
                    }
                    if (col == 0 && s.equalsIgnoreCase("action")) {
                        state = ACTIONS;
                        try {
                            s = st.nextToken();
                        }
                        catch (NoSuchElementException ex) {
                            ExceptionHandler.logException(16, "Error loading macro file", ex);
                            return;
                        }
                    }
                }
                if (state != 0 || col <= 0) {
                    if (state == DEVICES) {
                        devices[col - 1] = s.trim();
                    } else if (state == ACTIONS) {
                        actions[col - 1] = s.trim();
                    } else if (state == DATA) {
                        if (s.indexOf("\"") >= 0 && st.hasMoreTokens()) {
                            String nt;
                            System.out.println("Combine other columns");
                            do {
                                nt = st.nextToken();
                                s = s + nt;
                                System.out.println("s ends with \"? " + s.endsWith("\"") + "    " + s);
                            } while (!nt.endsWith("\"") && st.hasMoreTokens());
                            if (s.indexOf("\"") != s.lastIndexOf("\"")) {
                                s = s.substring(s.indexOf("\"") + 1, s.lastIndexOf("\""));
                            }
                        }
                        data[col - 1] = s.trim();
                    } else if (state == MACROS) {
                        if (col == 0) {
                            macro = new Macro(s);
                            macroName = s;
                            ++macroCount;
                            FileLogger.info("Loading Macro: " + s);
                            this._macroNames.put(macroName.toLowerCase(), macro);
                            this._macroNumbers.addElement(macro);
                        } else if (!s.equals("")) {
                            try {
                                double d = new Double(s);
                                macro.addAction((int)(d * 1000.0), commands[col - 1]);
                            }
                            catch (NumberFormatException ex) {
                                ExceptionHandler.logException(17, "Error loading macro file", ex);
                            }
                        }
                    }
                }
                if (!st.hasMoreTokens()) continue block30;
                try {
                    s = st.nextToken();
                }
                catch (NoSuchElementException ex) {
                    ExceptionHandler.logException(18, "Error loading macro file", ex);
                    return;
                }
            }
            for (col = 1; col < commands.length; ++col) {
                boolean isJniorPort;
                if (devices[col - 1] == null || devices[col - 1].equals("")) continue;
                int jniorOffset = 0;
                if (devices[col - 1].startsWith("DIN")) {
                    jniorOffset = 3;
                } else if (devices[col - 1].startsWith("ROUT")) {
                    jniorOffset = 4;
                }
                boolean bl = isJniorPort = jniorOffset > 0;
                if (isJniorPort) {
                    int port = 0;
                    try {
                        port = Integer.parseInt(devices[col - 1].substring(jniorOffset).trim());
                        isJniorPort = true;
                    }
                    catch (NumberFormatException ex) {
                        ExceptionHandler.logException(13, devices[col - 1] + " is Not JNIOR port", ex);
                    }
                    s = port > 8 ? actions[col - 1] + "+" + (port - 8) : actions[col - 1] + port;
                    if (actions[col - 1].toLowerCase().equals("cp") || actions[col - 1].toLowerCase().equals("sp")) {
                        try {
                            if ("".equals(data[col - 1])) {
                                data[col - 1] = "1";
                            }
                            double d = Double.valueOf(data[col - 1]);
                            s = s + "=" + (int)(d * 1000.0);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.logException(14, "error consuming close pulse or soft pulse", ex);
                        }
                    }
                    commands[col - 1] = s;
                    continue;
                }
                s = "device_";
                s = actions[col - 1].equals("Send Macro") ? s + devices[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Input Switch") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Set Fader") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Adjust Fader") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Fader Level") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Fader Setting") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Format Button") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Set Input") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Input Mode") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Set Mute") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (devices[col - 1].toLowerCase().startsWith("fpled") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (devices[col - 1].toLowerCase().startsWith("fpsound") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].toLowerCase().indexOf("intermission") != -1 ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equalsIgnoreCase("active audio preset") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equalsIgnoreCase("active control preset") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equalsIgnoreCase("master gain") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equalsIgnoreCase("master mute") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equalsIgnoreCase("master amp power on") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Send") ? s + devices[col - 1] + " send " + data[col - 1] : (actions[col - 1].equals("GET") ? s + devices[col - 1] + " GET " + data[col - 1] : (actions[col - 1].equals("PUT") ? s + devices[col - 1] + " PUT " + data[col - 1] : s + devices[col - 1] + " " + actions[col - 1]))))))))))))))))))));
                commands[col - 1] = s;
            }
            state = MACROS;
        }
    }

    public MacroResult runMacro(MacroRequestListener requester, String macroName) {
        return this.runMacro(requester, macroName, false);
    }

    public MacroResult runMacro(MacroRequestListener requester, String macroName, boolean checkPreshowLock) {
        System.out.println("executing " + macroName);
        MacroResult macroResult = new MacroResult();
        int macroNumber = -1;
        macroName = macroName.toLowerCase();
        try {
            macroNumber = new Integer(macroName);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (macroNumber == -1) {
            if (this._macroNames.size() == 0) {
                macroResult.setReason("no_macros_loaded");
                macroResult.setResult(false);
                if (null != requester) {
                    requester.macroResponse(new MacroResult(false, "no_macros_loaded"));
                }
            } else {
                Macro macro = (Macro)this._macroNames.get(macroName);
                macroResult = this.runMacro(requester, macro, macroName, checkPreshowLock);
            }
        } else if (this._macroNumbers.size() == 0) {
            macroResult.setReason("no_macros_loaded");
            macroResult.setResult(false);
            if (null != requester) {
                requester.macroResponse(new MacroResult(false, "no_macros_loaded"));
            }
        } else {
            Macro macro = (Macro)this._macroNumbers.elementAt(macroNumber - 1);
            macroResult = this.runMacro(requester, macro, macroName, checkPreshowLock);
        }
        return macroResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MacroResult runMacro(final MacroRequestListener requester, final Macro macro, final String macroName, final boolean checkPreshowLock) {
        Object object = Lock;
        synchronized (object) {
            while (this._loadingMacroFile) {
                try {
                    Lock.wait();
                    this._macroInProgress = true;
                }
                catch (InterruptedException ex) {
                    AppLog.error("Error locking macro lock in runMacro", ex);
                }
            }
        }
        MacroResult macroResult = new MacroResult();
        if (macroName.equalsIgnoreCase("reboot")) {
            this.executeRebootMacro();
        } else if (macro != null) {
            boolean currentlyExecuting;
            if (MacroConfiguration.shouldPreventMultipleInstances() && (currentlyExecuting = this._macrosInProgress.contains(macro))) {
                macroResult.setReason("macro_already_in_progress " + macro.getName());
                macroResult.setResult(false);
                FileLogger.info(macroResult.getReason());
                return macroResult;
            }
            try {
                Thread thd = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MacroFile.this._macrosInProgress.addElement(macro);
                            FileLogger.info(String.format("Starting Macro %s", macroName));
                            macro.setRequester(requester);
                            boolean success = macro.execute(checkPreshowLock);
                            FileLogger.info(String.format("Finished Macro %s", macroName));
                            if (requester != null) {
                                requester.macroResponse(new MacroResult(success, "executed_macro " + macroName).setMacro(macro));
                            }
                        }
                        catch (Exception ex) {
                            ExceptionHandler.logException(0, Thread.currentThread().getName(), ex);
                        }
                        MacroFile.this._macrosInProgress.removeElement(macro);
                    }
                }, "Run Macro");
                thd.setDaemon(true);
                thd.start();
                macroResult.setReason("executing");
            }
            catch (RuntimeException ex) {
                ExceptionHandler.logException(0, "Too Many Threads trying to start a new Macro", ex);
            }
        } else {
            macroResult.setReason("no_such_macro " + macroName);
            macroResult.setResult(false);
            if (requester != null) {
                requester.macroResponse(new MacroResult(false, "no_such_macro " + macroName));
            }
            FileLogger.info(macroResult.getReason());
        }
        Object object2 = Lock;
        synchronized (object2) {
            if (this._macrosInProgress.size() == 0) {
                this._macroInProgress = false;
                Lock.notifyAll();
            }
        }
        return macroResult;
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        FileLogger.info("JNIOR Protocol Client " + macroResult.getReason());
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
    }

    private void executeRebootMacro() {
        try {
            FileLogger.info("Sending reboot command");
            Rebooter.sendReboot();
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

