/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.macro;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreDevice;
import com.integpg.cinema.macro.MacroAction;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.util.Calendar;

public class ExternalDeviceAction
extends MacroAction {
    private String _deviceName;
    private TheatreDevice _device;

    public ExternalDeviceAction(String action, int delay) {
        super(action, delay);
    }

    @Override
    public void run() {
        boolean separateThread = RegistryHelper.getRegistryKey("AppData/Cinema/ExternalMacroInSeparateThread", false);
        if (separateThread) {
            Thread thd = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExternalDeviceAction.this.exectureMacroAction();
                }
            }, "External Device Action - " + this._originalAction);
            thd.start();
        } else {
            this.exectureMacroAction();
        }
    }

    private void exectureMacroAction() {
        System.out.println(Thread.currentThread().getName() + " - Execute Macro Action (" + this._action + ")");
        String lowerAction = this._action.toLowerCase();
        try {
            int firstSpace = this._action.indexOf(" ");
            this._deviceName = lowerAction.substring(7, firstSpace).trim();
            TheatreDevice device = (TheatreDevice)CinemaMain.INSTANCE.theatreDevices.get(this._deviceName);
            if (device.getHost() == null && device.getBaud() == 0) {
                if (Config.LOAD_BALANCE_OUTPUT != -1) {
                    int outputStates = JANOS.getOutputStates();
                    int loadBalanceState = outputStates >> Config.LOAD_BALANCE_OUTPUT - 1 & 1;
                    this._deviceName = this._deviceName.charAt(0) != '!' ? this._deviceName + (loadBalanceState == 0 ? "A" : "B") : this._deviceName.substring(1) + (loadBalanceState != 0 ? "A" : "B");
                } else {
                    Calendar cal = Calendar.getInstance();
                    int minute = cal.get(5);
                    this._deviceName = this._deviceName.charAt(0) != '!' ? this._deviceName + (minute % 2 == 0 ? "A" : "B") : this._deviceName.substring(1) + (minute % 2 != 0 ? "A" : "B");
                }
                this._deviceName = this._deviceName.toLowerCase();
                device = (TheatreDevice)CinemaMain.INSTANCE.theatreDevices.get(this._deviceName);
            }
            if (device != null) {
                this._device = device;
                String macroName = this._action.substring(firstSpace + 1);
                this._success = device.macroExecute(macroName);
            } else {
                System.out.println(this._deviceName + " not found");
                this._success = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            FileLogger.warn("External Device Macro Failed");
            this._success = false;
        }
        this._completed = true;
    }

    public String getDeviceName() {
        return this._deviceName;
    }
}

