/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class RawUdp
extends TheatreEthernetDevice {
    public RawUdp(String name) {
        super(name);
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        try {
            String newTermString = "";
            boolean backslashFound = false;
            if (this.terminationString != null) {
                for (int i = 0; i < this.terminationString.length(); ++i) {
                    if (this.terminationString.charAt(i) == '\\' && !backslashFound) {
                        backslashFound = true;
                        continue;
                    }
                    if (backslashFound) {
                        switch (this.terminationString.charAt(i)) {
                            case 'r': {
                                newTermString = newTermString + '\r';
                                break;
                            }
                            case 'n': {
                                newTermString = newTermString + '\n';
                                break;
                            }
                            case 't': {
                                newTermString = newTermString + '\t';
                                break;
                            }
                            case 'f': {
                                newTermString = newTermString + '\f';
                                break;
                            }
                            case 'b': {
                                newTermString = newTermString + '\b';
                                break;
                            }
                            case '0': {
                                newTermString = newTermString + '\u0000';
                            }
                        }
                    } else {
                        newTermString = newTermString + this.terminationString.charAt(i);
                    }
                    backslashFound = false;
                }
            }
            if (macroName.startsWith("send")) {
                String send = macroName.substring(5);
                String data = null;
                String converted = this.convertHexToString(send);
                data = converted != null ? converted : send;
                if (newTermString != null) {
                    data = data + newTermString;
                }
                if (data == null) {
                    FileLogger.warn(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                    return false;
                }
                int dataLen = data.length();
                byte[] dataBytes = new byte[dataLen];
                ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName.trim());
                this.send(dataBytes);
            }
        }
        catch (RuntimeException ex) {
            ExceptionHandler.logException(0, "Cinema.jnior: Raw Ethernet Execute macro Too Many Threads.", ex);
        }
        return true;
    }

    public void send(byte[] bytes) {
        try {
            InetAddress address = InetAddress.getByName(this.host);
            DatagramSocket ds = new DatagramSocket();
            DatagramPacket dp = new DatagramPacket(bytes, bytes.length, address, Integer.parseInt(this.port));
            ds.send(dp);
            ds.close();
        }
        catch (Exception ex) {
            FileLogger.error("Error sending UDP in raw ethernet: " + ex.getMessage());
        }
    }

    @Override
    public boolean login() {
        return false;
    }
}

