/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Config;
import com.integpg.cinema.Logic;
import com.integpg.cinema.Monitor.IOStateListener;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.janoslib.externalio.TypeFB;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.Vector;

public class CinemaIO
implements IOStateListener,
MacroRequestListener {
    private static int m_preshowLock = -1;
    private static int m_preshowLamp = -1;
    private int m_lastInputStates = 0;
    private int m_lastOutputStates = 0;
    private boolean m_quit = false;
    private Thread m_preshowLockThread = null;
    private Vector[] _inputLogicRules = new Vector[12];
    private Vector[] _outputLogicRules = new Vector[16];
    private Thread[] _delayedInputTriggerThreads = new Thread[12];

    public CinemaIO() {
        try {
            this.m_lastInputStates = this.assignInputStates(JANOS.getInputStates());
            this.m_lastOutputStates = this.assignOutputStates(JANOS.getOutputStates(), 65535);
            for (int channel = 1; channel <= 8; ++channel) {
                int state = this.m_lastInputStates >> channel - 1 & 1;
                this.doSlavingForInput(channel, state);
            }
            this.getInputStates();
            this.getOutputStates();
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, ex);
        }
    }

    public void monitorPreshowLock() {
        if (Config.PRESHOW_LOCK_OUTPUT != -1) {
            this.m_preshowLockThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int cnt = 5;
                    while (!CinemaIO.this.m_quit) {
                        try {
                            Thread.sleep(5000L);
                            if (cnt-- != 0) continue;
                            cnt = 5;
                        }
                        catch (InterruptedException ex) {
                            ExceptionHandler.logException(0, ex);
                        }
                        try {
                            CinemaIO.this.getOutputStates();
                        }
                        catch (IOException ex) {
                            ExceptionHandler.logException(0, ex);
                        }
                    }
                }
            }, "Monitor Preshow Lock");
            this.m_preshowLockThread.setDaemon(true);
            this.m_preshowLockThread.start();
        }
    }

    public void stop() {
        this.m_quit = true;
    }

    public void setOutputStates(long data, long mask) throws IOException {
        this.assignOutputStates((int)data, (int)mask);
        if (0L != (mask & 0xFFFFL)) {
            JANOS.setOutputStates((int)((int)data), (int)((int)mask));
        }
        mask &= 0xFFFFFFFFFFFF0000L;
        data &= 0xFFFFFFFFFFFF0000L;
        data >>= 16;
        if (0L != (mask >>= 16)) {
            TypeFB[] relayOutputModules = TypeFB.getDeviceArray();
            int internalOutputCount = UnitConfig.getOutputCount();
            int externalModuleIndex = 4 - internalOutputCount / 4;
            while (0L != mask) {
                relayOutputModules[externalModuleIndex].setOutputs((int)data, (int)mask);
                mask >>= 4;
                data >>= 4;
            }
        }
    }

    public void setOutputPulsed(long data, long mask, int duration) throws IOException {
        this.assignOutputStates((int)data, (int)mask);
        if (0L != (mask & 0xFFFFL)) {
            JANOS.setOutputPulsed((int)((int)data), (int)((int)mask), (int)duration);
        }
        mask &= 0xFFFFFFFFFFFF0000L;
        data &= 0xFFFFFFFFFFFF0000L;
        data >>= 16;
        if (0L != (mask >>= 16)) {
            TypeFB[] relayOutputModules = TypeFB.getDeviceArray();
            int internalOutputCount = UnitConfig.getOutputCount();
            int externalModuleIndex = 4 - internalOutputCount / 4;
            while (0L != mask) {
                relayOutputModules[externalModuleIndex].pulseOutputs((int)data, (int)mask, duration);
                mask >>= 4;
                data >>= 4;
            }
        }
    }

    public long getInputStates() throws IOException {
        return this.assignInputStates(JANOS.getInputStates());
    }

    public long getOutputStates() throws IOException {
        return this.assignOutputStates(JANOS.getOutputStates(), 65535);
    }

    private synchronized int assignInputStates(int states) {
        this.m_lastInputStates = states;
        return states;
    }

    private int assignOutputStates(int data, int mask) {
        int states = data;
        int changes = (states ^ this.m_lastOutputStates) & mask;
        for (int channel = 1; channel <= 16; ++channel) {
            if ((mask & 1) != 0) {
                int state = data & 1;
                if (Config.PRESHOW_LOCK_OUTPUT != -1 && channel == Config.PRESHOW_LOCK_OUTPUT) {
                    CinemaIO.setPreshowLock(state);
                } else if (channel != Config.MOVIE_STATUS_OUTPUT && channel == Config.PRESHOW_LAMP_OUTPUT && state != m_preshowLamp) {
                    m_preshowLamp = state;
                }
            }
            changes >>= 1;
            mask >>= 1;
            data >>= 1;
        }
        this.m_lastOutputStates = states;
        return states;
    }

    public static void setPreshowLock(int state) {
        if (Config.PRESHOW_LOCK_INVERT) {
            state = (state + 1) % 2;
        }
        if (state != m_preshowLock) {
            m_preshowLock = state;
            if (Config.MOVIE_STATUS_OUTPUT != -1) {
                try {
                    JANOS.setOutputStates((int)(~m_preshowLock << Config.MOVIE_STATUS_OUTPUT - 1), (int)(1 << Config.MOVIE_STATUS_OUTPUT - 1));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static int getPreshowLock() {
        return m_preshowLock;
    }

    public static int getMovieStatus() {
        return m_preshowLock;
    }

    public static void setPreshowLamp(int state) {
        m_preshowLamp = state;
    }

    public static int getPreshowLamp() {
        return m_preshowLamp;
    }

    public void doSlavingForInput(int channel, int state) {
        for (int output = 0; output < 16; ++output) {
            try {
                if (Config.SLAVED_IO[output] == channel) {
                    this.setOutputStates(state << output, 1 << output);
                    continue;
                }
                if (Config.SLAVED_IO[output] != -channel) continue;
                this.setOutputStates((state + 1) % 2 << output, 1 << output);
                continue;
            }
            catch (IOException ex) {
                ExceptionHandler.logException(0, "Error performing slaving on output " + (output + 1), ex);
            }
        }
    }

    @Override
    public void ioStateChange(int io, byte channel, byte state, long inputStateMask, long outputStateMask) {
        block18: {
            System.out.println((0 == io ? "Input" : "Output") + " Trigger IO Change on channel " + channel + ":" + state);
            switch (io) {
                case 0: {
                    if (this._inputLogicRules[channel - 1] == null) break;
                    int logicRuleCount = this._inputLogicRules[channel - 1].size();
                    for (int i = 0; i < logicRuleCount; ++i) {
                        Logic logic = (Logic)this._inputLogicRules[channel - 1].elementAt(i);
                        int result = logic.evaluate(inputStateMask, outputStateMask);
                        if (result != 1) continue;
                        logic.execute();
                    }
                    break;
                }
                case 1: {
                    if (this._outputLogicRules[channel - 1] == null) break;
                    int logicRuleCount = this._outputLogicRules[channel - 1].size();
                    for (int i = 0; i < logicRuleCount; ++i) {
                        Logic logic = (Logic)this._outputLogicRules[channel - 1].elementAt(i);
                        int result = logic.evaluate(inputStateMask, outputStateMask);
                        if (result != 1) continue;
                        logic.execute();
                    }
                    break;
                }
            }
            if (Config.CLIENT_UNSOLICITED_IO && CinemaMain.INSTANCE.clientComm != null) {
                if (io == 0) {
                    try {
                        if (Config.CLIENT_SEND_COUNTS) {
                            int count = JANOS.getInputCounter((int)(channel - 1));
                            CinemaMain.INSTANCE.clientComm.send("IN" + channel + "=" + state + "," + count);
                            break block18;
                        }
                        CinemaMain.INSTANCE.clientComm.send("IN" + channel + "=" + state);
                    }
                    catch (IOException ex) {
                        ExceptionHandler.logException(0, ex);
                    }
                } else {
                    if (Config.CLIENT_UNSOLICITED_IO && CinemaMain.INSTANCE.clientComm != null) {
                        try {
                            CinemaMain.INSTANCE.clientComm.send("OUT" + channel + "=" + state);
                        }
                        catch (IOException ex) {
                            ExceptionHandler.logException(0, ex);
                        }
                    }
                    this.m_lastOutputStates = state == 0 ? (this.m_lastOutputStates &= 0xFFFF ^ 1 << channel - 1) : (this.m_lastOutputStates |= 1 << channel - 1);
                }
            }
        }
        if (io == 0) {
            this.doSlavingForInput(channel, state);
            this.checkInputTriggerMacros(channel, state);
        } else if (io == 1) {
            this.checkOutputTriggerMacros(channel, state);
        }
    }

    private void checkForDelayedTrigger(int channel) {
        try {
            System.out.println("Start timer to check for delayed trigger?");
            Thread.sleep(Config.INPUT_TRIGGER_DELAY_TIMES[channel]);
            int state = JANOS.getInputStates() >> channel & 1;
            System.out.println("Is delayed trigger input still high? " + state);
            if (state == 1) {
                CinemaMain.MacroFile.runMacro(this, Config.INPUT_TRIGGER_MACROS[channel]);
            }
        }
        catch (Exception ex) {
            System.out.println("Delayed trigger trimer interrupted");
        }
        this._delayedInputTriggerThreads[channel] = null;
    }

    private void checkInputTriggerMacros(final int channel, int state) {
        try {
            if (channel <= Config.INPUT_TRIGGER_MACROS.length && Config.INPUT_TRIGGER_MACROS[channel - 1] != null && !Config.INPUT_TRIGGER_MACROS[channel - 1].equals("none")) {
                if (state == 1) {
                    if (Config.INPUT_TRIGGER_DELAY_TIMES[channel - 1] > 0) {
                        if (this._delayedInputTriggerThreads[channel - 1] == null) {
                            this._delayedInputTriggerThreads[channel - 1] = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    CinemaIO.this.checkForDelayedTrigger(channel - 1);
                                }
                            });
                            this._delayedInputTriggerThreads[channel - 1].setDaemon(true);
                            this._delayedInputTriggerThreads[channel - 1].start();
                        }
                    } else {
                        CinemaMain.MacroFile.runMacro(this, Config.INPUT_TRIGGER_MACROS[channel - 1]);
                    }
                } else if (this._delayedInputTriggerThreads[channel - 1] != null) {
                    this._delayedInputTriggerThreads[channel - 1].interrupt();
                }
            }
        }
        catch (Exception ex) {
            FileLogger.error("error checking output triggers", ex);
        }
    }

    private void checkOutputTriggerMacros(int channel, int state) {
        try {
            if (channel <= Config.OUTPUT_TRIGGER_MACROS.length && Config.OUTPUT_TRIGGER_MACROS[channel - 1] != null && !Config.OUTPUT_TRIGGER_MACROS[channel - 1].equals("none") && state == 1) {
                CinemaMain.MacroFile.runMacro(this, Config.OUTPUT_TRIGGER_MACROS[channel - 1]);
            }
        }
        catch (Exception ex) {
            FileLogger.error("error checking output triggers", ex);
        }
    }

    public void macroResponse(String response, boolean success) {
        FileLogger.info("Input Trigger " + response);
    }

    void addLogic(Logic logic) {
        int channel = 0;
        int inputsUsedMask = logic.getInputsUsedMask();
        while (inputsUsedMask != 0) {
            if ((inputsUsedMask & 1) != 0) {
                if (this._inputLogicRules[channel] == null) {
                    this._inputLogicRules[channel] = new Vector();
                }
                this._inputLogicRules[channel].addElement(logic);
            }
            inputsUsedMask >>= 1;
            ++channel;
        }
        channel = 0;
        int outputsUsedMask = logic.getOutputsUsedMask();
        while (outputsUsedMask != 0) {
            if ((outputsUsedMask & 1) != 0) {
                if (this._outputLogicRules[channel] == null) {
                    this._outputLogicRules[channel] = new Vector();
                    CinemaMain.INSTANCE.m_stateMonitor.addStateListener(this, 1, channel + 1);
                }
                this._outputLogicRules[channel].addElement(logic);
            }
            outputsUsedMask >>= 1;
            ++channel;
        }
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
    }

    static {
        TypeFB[] typeFBArray = TypeFB.getDeviceArray();
    }
}

