/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.externalmodules;

import com.integ.janoslib.externalmodules.DeviceInfo;
import com.integpg.system.ArrayUtils;

public class FourTwentyModule
extends DeviceInfo {
    private final double[] _scaledIns = new double[4];
    private final double[] _savedScaledIns = new double[4];
    private final double[] _scaledOuts = new double[4];
    private final double[] _savedScaledOuts = new double[4];

    public FourTwentyModule(long deviceAddress, int index) {
        super(deviceAddress, index);
    }

    @Override
    public void update() {
        byte[] deviceBlock = this.read();
        if (this.Updated) {
            double scale;
            int rawIn;
            int i;
            for (i = 0; i < 4; ++i) {
                rawIn = ArrayUtils.getShort((byte[])deviceBlock, (int)(i * 2)) & 0xFFFF;
                this._scaledIns[i] = (double)rawIn / 65520.0 * 16.0 + 4.0;
                if (-1 == this._significantDecimalPlaces) continue;
                scale = Math.pow(10.0, this._significantDecimalPlaces);
                this._scaledIns[i] = (double)Math.round(this._scaledIns[i] * scale) / scale;
            }
            for (i = 0; i < 4; ++i) {
                if (this._savedScaledIns[i] == this._scaledIns[i]) continue;
                this._savedScaledIns[i] = this._scaledIns[i];
                System.out.println(String.format("4-20ma In[%d] updated: " + this._precisionString, i, this._scaledIns[i]));
            }
            for (i = 0; i < 2; ++i) {
                rawIn = ArrayUtils.getShort((byte[])deviceBlock, (int)(i * 2 + 8)) & 0xFFFF;
                this._scaledOuts[i] = (double)rawIn / 65520.0 * 16.0 + 4.0;
                if (-1 == this._significantDecimalPlaces) continue;
                scale = Math.pow(10.0, this._significantDecimalPlaces);
                this._scaledOuts[i] = (double)Math.round(this._scaledOuts[i] * scale) / scale;
            }
            for (i = 0; i < 2; ++i) {
                if (this._savedScaledOuts[i] == this._scaledOuts[i]) continue;
                this._savedScaledOuts[i] = this._scaledOuts[i];
                System.out.println(String.format("4-20ma Out[%d] updated: " + this._precisionString, i, this._scaledOuts[i]));
            }
        }
    }
}

