/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.serial;

import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.comm.PortInUseException;
import com.integpg.comm.SerialPort;
import com.integpg.comm.UnsupportedCommOperationException;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.io.IOException;

public class SerialHelper {
    public static void getConfiguration(String registryNode, String defaultPort) {
        String serialPortName = RegistryHelper.getRegistryKey(registryNode + "/SerialPort", defaultPort);
        int baudRate = RegistryHelper.getRegistryKey(registryNode + "/Baud", 19200);
        int dataBits = RegistryHelper.getRegistryKey(registryNode + "/DataBits", 8);
        int stopBits = RegistryHelper.getRegistryKey(registryNode + "/StopBits", 1);
        int parity = RegistryHelper.getRegistryKey(registryNode + "/Parity", 0);
    }

    public static SerialPort getSerialPort(String registryNode, String defaultPort) {
        COMSerialPort serial = null;
        String serialPortName = RegistryHelper.getRegistryKey(registryNode + "/SerialPort", defaultPort);
        int baudRate = RegistryHelper.getRegistryKey(registryNode + "/Baud", 19200);
        int dataBits = RegistryHelper.getRegistryKey(registryNode + "/DataBits", 8);
        int stopBits = RegistryHelper.getRegistryKey(registryNode + "/StopBits", 1);
        int parity = RegistryHelper.getRegistryKey(registryNode + "/Parity", 0);
        if (serialPortName.equalsIgnoreCase("rs232")) {
            serial = new COMSerialPort();
            COMSerialPort.setBootDialog((boolean)false);
        } else if (serialPortName.equalsIgnoreCase("aux")) {
            serial = new AUXSerialPort();
        }
        if (serial == null) {
            return null;
        }
        try {
            long duration = 60000L - JANOS.uptimeMillis();
            if (serial instanceof COMSerialPort && duration > 0L) {
                FileLogger.info("Waiting to take over the COM Port");
                try {
                    Thread.sleep(duration);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            serial.open();
            serial.setSerialPortParams(baudRate, dataBits, stopBits, parity);
        }
        catch (PortInUseException | UnsupportedCommOperationException | IOException ex) {
            throw new RuntimeException("Unable to configure serial port: " + ex.getMessage() + ": " + baudRate + "," + dataBits + "," + stopBits + "," + parity);
        }
        return serial;
    }
}

