/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.threading;

import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.Log;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.threading.ThreadWorker;

public class ThreadPool {
    public static final Log LOG = FileLog.getLog(new LogOptions("/" + Application.getAppName() + "_threadpool.log").setMaxFileSizeInKb(64));
    private static final int THREAD_POOL_SIZE = 10;
    private static ThreadWorker[] _threadPool = new ThreadWorker[10];
    private static int _threadWorkerCount = 0;
    private static final Queue _tasks = new Queue();
    private static boolean _cancelled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(Runnable task) {
        ThreadWorker threadWorker = null;
        Object object = _threadPool;
        synchronized (_threadPool) {
            if (_cancelled) {
                throw new RuntimeException("ThreadPool has been cancelled");
            }
            for (int i = 0; i < _threadWorkerCount; ++i) {
                if (null == _threadPool[i] || _threadPool[i].isBusy()) continue;
                threadWorker = _threadPool[i];
                break;
            }
            if (threadWorker == null && _threadWorkerCount < 10) {
                String s = "ThreadWorker-" + _threadWorkerCount;
                LOG.info(s + " started");
                threadWorker = new ThreadWorker(s);
                threadWorker.start();
                ThreadPool._threadPool[ThreadPool._threadWorkerCount++] = threadWorker;
            }
            // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
            if (threadWorker != null) {
                threadWorker.setTask(task);
                return true;
            }
            LOG.info("no ThreadWorker available.  queue task");
            object = _tasks;
            synchronized (object) {
                _tasks.enqueue(task);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void threadWorkerAvailable(ThreadWorker threadWorker) {
        Runnable r = null;
        Queue queue = _tasks;
        synchronized (queue) {
            if (!_tasks.isEmpty()) {
                r = (Runnable)_tasks.dequeue();
            }
        }
        if (r != null) {
            LOG.info(threadWorker.getName() + " execute queued task");
            threadWorker.setTask(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel() {
        ThreadWorker[] threadWorkerArray = _threadPool;
        synchronized (_threadPool) {
            _cancelled = true;
            Queue queue = _tasks;
            synchronized (queue) {
                while (!_tasks.isEmpty()) {
                    _tasks.dequeue();
                }
            }
            for (int i = 0; i < _threadWorkerCount; ++i) {
                _threadPool[i].cancel();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void setThreadWorkerLimit(int limit) {
        ThreadPool.cancel();
        _threadPool = new ThreadWorker[limit];
        _cancelled = false;
    }
}

