/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.macro;

import com.integpg.cinema.CinemaIO;
import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.macro.MacroAction;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.system.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class InternalIOAction
extends MacroAction {
    byte[] _cachedAction = null;

    public InternalIOAction(String action, int delay) {
        super(action, delay);
    }

    @Override
    public void run() {
        try {
            if (this._cachedAction != null && this._cachedAction.length > 0) {
                int index = 0;
                byte action = this._cachedAction[index++];
                short channelMask = ArrayUtils.getShort((byte[])this._cachedAction, (int)index);
                short statesMask = ArrayUtils.getShort((byte[])this._cachedAction, (int)(index += 2));
                index += 2;
                switch (action) {
                    case 1: {
                        int duration = ArrayUtils.getInt((byte[])this._cachedAction, (int)index);
                        index += 4;
                        CinemaMain.INSTANCE.cinemaio.setOutputPulsed(statesMask, channelMask, duration);
                        break;
                    }
                    case 2: {
                        CinemaMain.INSTANCE.cinemaio.setOutputStates(statesMask, channelMask);
                    }
                }
                this._success = true;
            } else {
                this._cachedAction = InternalIOAction.parseCommand(this._action.toLowerCase());
                this._success = this._cachedAction != null;
            }
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, ex);
        }
        this._completed = true;
    }

    public static byte[] parseCommand(String lowerCommand) throws IOException {
        if (lowerCommand.indexOf(",") >= 0) {
            int begin = 0;
            while (begin >= 0) {
                int end = lowerCommand.indexOf(",", begin + 1);
                InternalIOAction.parseCommand(lowerCommand, begin, end);
                if (end >= 0) {
                    // empty if block
                }
                begin = ++end;
            }
        } else {
            return InternalIOAction.parseCommand(lowerCommand, 0, lowerCommand.length());
        }
        return null;
    }

    public static byte[] parseCommand(String lowerCommand, int beginIndex, int endIndex) throws IOException {
        CinemaIO cinemaio = CinemaMain.INSTANCE.cinemaio;
        if (endIndex == -1) {
            endIndex = lowerCommand.length();
        }
        lowerCommand = lowerCommand.substring(beginIndex, endIndex);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        long states = 0L;
        long mask = 0L;
        int parameter = 1000;
        boolean close = false;
        boolean open = false;
        boolean toggle = false;
        boolean reset = false;
        boolean setcounters = false;
        boolean dosetcounters = false;
        boolean pulse = false;
        boolean value = false;
        boolean stop = false;
        int shift = 0;
        int len = lowerCommand.length();
        char[] chars = new char[len];
        lowerCommand.getChars(0, len, chars, 0);
        int currentStates = (int)cinemaio.getOutputStates();
        states = currentStates;
        block12: for (int i = 0; i < len && !stop; ++i) {
            switch (chars[i]) {
                case 'c': {
                    close = true;
                    open = false;
                    toggle = false;
                    reset = false;
                    setcounters = false;
                    continue block12;
                }
                case 'o': {
                    open = true;
                    close = false;
                    toggle = false;
                    reset = false;
                    setcounters = false;
                    continue block12;
                }
                case 't': {
                    open = false;
                    close = false;
                    toggle = true;
                    reset = false;
                    setcounters = false;
                    continue block12;
                }
                case 'p': {
                    pulse = true;
                    continue block12;
                }
                case '=': {
                    char c;
                    int n;
                    StringBuffer sb = new StringBuffer();
                    for (n = i + 1; n < lowerCommand.length() && Character.isDigit(c = lowerCommand.charAt(n)); ++n) {
                        sb.append(c);
                        ++i;
                    }
                    String cmd = sb.toString();
                    for (n = 0; n < cmd.length(); ++n) {
                        if (Character.isDigit(cmd.charAt(n))) continue;
                        return null;
                    }
                    parameter = new Integer(cmd);
                    value = true;
                    continue block12;
                }
                case 's': {
                    dosetcounters = true;
                    setcounters = true;
                    open = false;
                    close = false;
                    toggle = false;
                    reset = false;
                    continue block12;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': {
                    if (!(open || close || toggle || reset || setcounters)) {
                        return null;
                    }
                    int n = lowerCommand.charAt(i) - 49;
                    if (shift == 0) {
                        mask |= (long)(1 << n);
                        if (close) {
                            states |= (long)(1 << n);
                        } else if (open) {
                            states &= (long)(~(1 << n));
                        } else if (toggle) {
                            states ^= (long)(1 << n);
                        }
                    } else {
                        mask |= (long)(1 << n + 8 * shift);
                        if (close) {
                            states |= (long)(1 << n << 8 * shift);
                        } else if (open) {
                            states &= (long)(~(1 << n << 8 * shift));
                        } else if (toggle) {
                            states ^= (long)(1 << n << 8 * shift);
                        }
                    }
                    shift = 0;
                    continue block12;
                }
                case '+': {
                    ++shift;
                    continue block12;
                }
                case '*': {
                    if (!(open || close || reset || setcounters)) {
                        return null;
                    }
                    mask |= 0xFFFFFFFFL;
                    if (close) {
                        states = 0xFFFFFFFFL;
                        continue block12;
                    }
                    if (!open) continue block12;
                    states = 0L;
                    continue block12;
                }
                case ' ': {
                    continue block12;
                }
            }
        }
        if (value && !pulse && !dosetcounters) {
            return null;
        }
        if (value && pulse && dosetcounters) {
            return null;
        }
        if (dosetcounters && !value) {
            return null;
        }
        if (mask != 0L) {
            if (pulse) {
                if (dos != null) {
                    dos.writeByte(1);
                    dos.writeShort((short)mask);
                    dos.writeShort((short)states);
                    dos.writeInt(parameter);
                    cinemaio.setOutputPulsed(states, mask, parameter);
                }
            } else if (!toggle) {
                if (dos != null) {
                    dos.writeByte(2);
                    dos.writeShort((short)mask);
                    dos.writeShort((short)states);
                }
                cinemaio.setOutputStates(states, mask);
            } else if (toggle) {
                baos = new ByteArrayOutputStream();
                dos = new DataOutputStream(baos);
                cinemaio.setOutputStates(states, mask);
            }
        }
        if (baos != null) {
            return baos.toByteArray();
        }
        return null;
    }
}

