/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.devices.TheatreDevice;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.comm.PortInUseException;
import com.integpg.comm.SerialPort;
import com.integpg.comm.UnsupportedCommOperationException;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.system.JANOS;
import java.io.IOException;

public abstract class TheatreSerialDevice
extends TheatreDevice {
    protected SerialPort serial;
    protected String portName = "Not Open";

    public TheatreSerialDevice(String name) {
        super(name);
    }

    @Override
    public abstract boolean macroExecute(String var1);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean connect(String host, String port) {
        boolean success = false;
        if (this.serial != null) {
            return true;
        }
        this.portName = port;
        System.out.println(this.name + " Opening serial port at " + port + ", " + this.baud + ", " + this.dataBits + ", " + this.stopBits + ", " + this.parity);
        if (port.toLowerCase().equals("aux")) {
            this.serial = new AUXSerialPort();
            success = true;
        } else if (port.toLowerCase().equals("rs232")) {
            this.serial = new COMSerialPort();
            success = true;
        } else {
            System.out.println("Cinema.JNIOR Serial Device: Bad Serial Port Selection");
            JANOS.syslog((String)"Cinema.JNIOR Serial Device: Bad Serial Port Selection");
            return false;
        }
        System.out.println("Opening " + port + " at " + this.baud + ", " + this.dataBits + ", " + this.stopBits + ", " + this.parity);
        try {
            this.serial.open();
            this.serial.setSerialPortParams(this.baud, this.dataBits, this.stopBits, this.parity);
        }
        catch (PortInUseException ex) {
            throw new RuntimeException("Unable to configure serial port: " + ex.getMessage() + ": " + this.baud + "," + this.dataBits + "," + this.stopBits + "," + this.parity);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to configure serial port: " + ex.getMessage() + ": " + this.baud + "," + this.dataBits + "," + this.stopBits + "," + this.parity);
        }
        catch (UnsupportedCommOperationException ex) {
            ExceptionHandler.logException(0, ex);
            return false;
        }
        try {
            this.serial.enableReceiveTimeout(100);
        }
        catch (UnsupportedCommOperationException ex) {
            ExceptionHandler.logException(0, ex);
            return false;
        }
        if (success) {
            try {
                this.out = this.serial.getOutputStream();
            }
            catch (IOException ex) {
                ExceptionHandler.logException(0, ex);
                success = false;
            }
        }
        return success;
    }

    public boolean ensureConnection() {
        return this.connect(this.host, this.port);
    }

    public abstract boolean login();

    @Override
    public void disconnect() {
        if (this.serial != null) {
            this.serial.close();
            this.serial = null;
            this.in = null;
            this.out = null;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            this.disconnect();
        }
        finally {
            super.finalize();
        }
    }
}

