/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreSerialDevice;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class RawSerial
extends TheatreSerialDevice {
    public RawSerial(String name) {
        super(name);
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        try {
            String newTermString = "";
            boolean backslashFound = false;
            if (this.terminationString != null) {
                for (int i = 0; i < this.terminationString.length(); ++i) {
                    if (this.terminationString.charAt(i) == '\\' && !backslashFound) {
                        backslashFound = true;
                        continue;
                    }
                    if (backslashFound) {
                        switch (this.terminationString.charAt(i)) {
                            case 'r': {
                                newTermString = newTermString + '\r';
                                break;
                            }
                            case 'n': {
                                newTermString = newTermString + '\n';
                                break;
                            }
                            case 't': {
                                newTermString = newTermString + '\t';
                                break;
                            }
                            case 'f': {
                                newTermString = newTermString + '\f';
                                break;
                            }
                            case 'b': {
                                newTermString = newTermString + '\b';
                                break;
                            }
                            case '0': {
                                newTermString = newTermString + '\u0000';
                            }
                        }
                    } else {
                        newTermString = newTermString + this.terminationString.charAt(i);
                    }
                    backslashFound = false;
                }
            }
            if (macroName.startsWith("send")) {
                String send = macroName.substring(5);
                String data = null;
                String converted = this.convertHexToString(send);
                data = converted != null ? converted : send;
                if (newTermString != null) {
                    data = data + newTermString;
                }
                System.out.println(this.portName + " " + data);
                if (data == null) {
                    FileLogger.warn(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                    return false;
                }
                int dataLen = data.length();
                byte[] dataBytes = new byte[dataLen];
                ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
                this.send(dataBytes);
            }
        }
        catch (RuntimeException ex) {
            ExceptionHandler.logException(0, "Cinema.jnior: Raw Serial Execute Macro Too Many Threads.", ex);
        }
        return true;
    }

    public void send(byte[] bytes) {
        if (this.serial == null) {
            this.ensureConnection();
        }
        try {
            if (this.out != null) {
                this.out.write(bytes);
            } else {
                System.out.println("output stream is null");
            }
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, ex);
        }
    }

    @Override
    public boolean login() {
        return false;
    }
}

