/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.http.HttpConnection;
import com.integpg.janoslib.http.HttpURL;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;
import java.net.MalformedURLException;

public class HttpRequest
extends TheatreEthernetDevice {
    public HttpRequest(String name) {
        super(name);
    }

    @Override
    public boolean macroExecute(String macroName) {
        System.out.println("macroName: " + macroName);
        if (macroName.toLowerCase().startsWith("get")) {
            String send = macroName.substring(4);
            String data = null;
            String converted = this.convertHexToString(send);
            data = converted != null ? converted : send;
            if (data == null) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            byte[] dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
            return this.send("GET", dataBytes);
        }
        if (macroName.toLowerCase().startsWith("put")) {
            String send = macroName.substring(4);
            String data = null;
            String converted = this.convertHexToString(send);
            data = converted != null ? converted : send;
            if (data == null) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            byte[] dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
            return this.send("GET", dataBytes);
        }
        return false;
    }

    @Override
    public boolean login() {
        return false;
    }

    public boolean send(String method, byte[] dataBytes) {
        try {
            String urlString = "http://" + this.host + ":" + this.port;
            String dataString = new String(dataBytes);
            if (!dataString.startsWith("/")) {
                urlString = urlString + "/";
            }
            urlString = urlString + dataString;
            System.out.println("urlString: " + urlString);
            HttpURL url = new HttpURL(urlString);
            HttpConnection httpConnection = new HttpConnection(url);
            httpConnection.setRequestMethod(method);
            httpConnection.connect();
            httpConnection.sendHeaders();
            httpConnection.sendData();
            httpConnection.close();
            return true;
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

