/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integpg.cinema.Config;
import com.integpg.cinema.devices.BarcoRpcCommand;
import com.integpg.cinema.devices.BarcoStatus;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import com.integpg.system.SystemMsg;
import java.io.IOException;

public class Barco
extends TheatreEthernetDevice {
    private static final byte START_BYTE = -2;
    private static final byte STOP_BYTE = -1;
    private static final byte[] macroExecuteCommandBytes = new byte[]{-24, -127};
    private static final byte[] closeDowserCommandBytes = new byte[]{35, 66, 0};
    private static final byte[] openDowserCommandBytes = new byte[]{34, 66, 0};
    private static final byte[] lampOnCommandBytes = new byte[]{118, 26, 1};
    private static final byte[] lampOffCommandBytes = new byte[]{118, 26, 0};

    public Barco(String name) {
        super(name);
        this.port = "43680";
        m_projectors.put(name, this);
    }

    public BarcoStatus getStatus() {
        BarcoStatus bs = new BarcoStatus();
        byte[] sendBytes = new byte[]{103};
        byte[] recvBytes = this.send(0, sendBytes, null);
        if (recvBytes == null) {
            return null;
        }
        FileLogger.info(Config.DEVICES_LOG, recvBytes.length + " status bytes received " + HexUtils.hexDump(recvBytes));
        if (recvBytes != null && recvBytes.length >= 10) {
            bs.lampOn = recvBytes[0] >> 6 == 1;
            FileLogger.info(Config.DEVICES_LOG, "Lamp On " + bs.lampOn);
        }
        if ((recvBytes = this.send(0, sendBytes = new byte[]{33, 66}, null)) == null) {
            return null;
        }
        FileLogger.info(Config.DEVICES_LOG, recvBytes.length + " shutter bytes received " + HexUtils.hexDump(recvBytes));
        bs.dowserOpen = recvBytes[10] == 1;
        FileLogger.info(Config.DEVICES_LOG, "Shutter Status " + bs.dowserOpen);
        sendBytes = new byte[]{-24, 1};
        recvBytes = this.send(0, sendBytes, null);
        FileLogger.info(Config.DEVICES_LOG, recvBytes.length + " status bytes received " + HexUtils.hexDump(recvBytes));
        if (recvBytes.length > 11) {
            bs.lastMacroExecuted = new String(recvBytes, 10, recvBytes.length - 12);
            FileLogger.info(Config.DEVICES_LOG, "Last macro was " + bs.lastMacroExecuted);
        }
        this.disconnect();
        return bs;
    }

    @Override
    public synchronized boolean macroExecute(final String macroName) {
        System.out.println(this.name + " Barco macro: " + macroName);
        if ("43731".equals(this.port)) {
            System.out.println("Send command to barco application");
            BarcoRpcCommand rpc = new BarcoRpcCommand(macroName);
            SystemMsg systemMsg = new SystemMsg();
            systemMsg.type = 43731;
            systemMsg.msg = rpc.toString().getBytes();
            MessagePumpEngine.postMessage(systemMsg);
            return true;
        }
        if (macroName.toLowerCase().equals("close dowser")) {
            try {
                if (this.send(0, closeDowserCommandBytes, null) != null) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Dowser Closed");
                    return true;
                }
                FileLogger.info(Config.DEVICES_LOG, this.name + " Error Closing Dowser");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Closing Dowser");
            }
        } else if (macroName.toLowerCase().equals("open dowser")) {
            try {
                if (this.send(0, openDowserCommandBytes, null) != null) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Dowser Opened");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Opening Dowser");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Opening Dowser");
            }
        } else if (macroName.toLowerCase().equals("lamp on")) {
            try {
                if (this.send(0, lampOnCommandBytes, null) != null) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Lamp On");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Lamp On");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Lamp On");
            }
        } else if (macroName.toLowerCase().equals("lamp off")) {
            try {
                if (this.send(0, lampOffCommandBytes, null) != null) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Lamp Off");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Lamp Off");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Lamp Off");
            }
        } else {
            if (macroName.toLowerCase().startsWith("send")) {
                String send = macroName.substring(5);
                String data = null;
                String converted = this.convertHexToString(send);
                data = converted != null ? converted : send;
                if (data == null) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                    return false;
                }
                int dataLen = data.length();
                byte[] dataBytes = new byte[dataLen];
                ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
                return this.send(0, dataBytes, null) == null;
            }
            try {
                Thread thd = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int macroNameLen = macroName.length();
                        byte[] cMacroName = new byte[macroNameLen + 1];
                        ArrayUtils.arraycopy((Object)macroName.getBytes(), (int)0, (Object)cMacroName, (int)0, (int)macroNameLen);
                        FileLogger.info(Config.DEVICES_LOG, Barco.this.name + " Executing Macro - " + macroName);
                        try {
                            if (Barco.this.send(0, macroExecuteCommandBytes, cMacroName) != null) {
                                FileLogger.info(Config.DEVICES_LOG, Barco.this.name + " Executed Macro - " + macroName + " Successfully");
                            } else {
                                FileLogger.error(Config.DEVICES_LOG, Barco.this.name + " Executed Macro - " + macroName + " Unsuccessfully");
                            }
                        }
                        catch (Exception ex) {
                            FileLogger.error(Config.DEVICES_LOG, Barco.this.name + " Executed Macro - " + macroName + " Unsuccessfully");
                        }
                    }
                }, "Barco Execute Macro");
                thd.start();
                return true;
            }
            catch (Exception ex) {
                ExceptionHandler.logException(0, ex);
            }
        }
        this.disconnect();
        return false;
    }

    @Override
    public boolean login() {
        return true;
    }

    public synchronized byte[] send(int projectorAddress, byte[] commandBytes, byte[] dataBytes) {
        int i;
        if (!this.ensureConnection()) {
            FileLogger.warn(Config.DEVICES_LOG, this.name + " ensure connection failed");
            return null;
        }
        boolean success = true;
        int checksum = projectorAddress;
        for (i = 0; i < commandBytes.length; ++i) {
            checksum += commandBytes[i];
        }
        if (dataBytes != null) {
            for (i = 0; i < dataBytes.length; ++i) {
                checksum += dataBytes[i];
            }
        }
        checksum %= 256;
        this.bos.reset();
        this.bos.write(-2);
        this.bos.write((byte)projectorAddress);
        this.bos.write(commandBytes, 0, commandBytes.length);
        if (dataBytes != null) {
            this.bos.write(dataBytes, 0, dataBytes.length);
        }
        this.bos.write(checksum);
        this.bos.write(-1);
        try {
            this.out.write(this.bos.toByteArray());
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, ex);
            try {
                this.disconnect();
                if (this.ensureConnection()) {
                    this.out.write(this.bos.toByteArray());
                } else {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " ensure connection failed");
                    success = false;
                }
            }
            catch (IOException ex2) {
                ExceptionHandler.logException(0, ex2);
                this.disconnect();
                success = false;
            }
        }
        return this.bos.toByteArray();
    }
}

