/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class ScheduledConfig {
    private static final String DAYS_OF_WEEK_STRING = "sumotuwethfrsa";
    private static final String MONTHS_OF_YEAR_STRING = "janfebmaraprmayjunjulaugsepoctnovdec";
    private boolean[] DaysOfWeek = new boolean[7];
    private boolean[] MonthsOfYear = new boolean[12];
    private boolean _isWeekly = false;
    private int _dayOfMonth = -1;
    private Date StartTime = null;
    private long Interval;
    private String Action;

    public boolean shouldExecute() {
        if (this._isWeekly) {
            return this.isCurrentDayOfWeekValid();
        }
        int dayOfMonth = Calendar.getInstance().get(5);
        return this.isCurrentMonthOfYearValid() && this._dayOfMonth == dayOfMonth;
    }

    private boolean isCurrentDayOfWeekValid() {
        int dayOfWeekIndex = Calendar.getInstance().get(7) - 1;
        System.out.println(" " + DAYS_OF_WEEK_STRING.substring(dayOfWeekIndex * 2, (dayOfWeekIndex + 1) * 2) + ": " + this.DaysOfWeek[dayOfWeekIndex]);
        return this.DaysOfWeek[dayOfWeekIndex];
    }

    private boolean isCurrentMonthOfYearValid() {
        int monthOfYearIndex = Calendar.getInstance().get(2);
        System.out.println(" " + MONTHS_OF_YEAR_STRING.substring(monthOfYearIndex * 3, (monthOfYearIndex + 1) * 3) + ": " + this.MonthsOfYear[monthOfYearIndex]);
        return this.MonthsOfYear[monthOfYearIndex];
    }

    public Date getStartTime() {
        return this.StartTime;
    }

    public long getInterval() {
        return this.Interval;
    }

    public String getAction() {
        return this.Action;
    }

    public static ScheduledConfig parse(String[] configParts) {
        int i;
        ScheduledConfig config = new ScheduledConfig();
        if ("none".equalsIgnoreCase(configParts[0])) {
            return null;
        }
        configParts[0] = configParts[0].toLowerCase();
        if ("daily".equalsIgnoreCase(configParts[0])) {
            config.DaysOfWeek = new boolean[]{true, true, true, true, true, true, true};
            config._isWeekly = true;
        } else if (configParts[0].startsWith("monthly")) {
            int lparen = configParts[0].indexOf("(");
            int rparen = configParts[0].indexOf(")");
            config._dayOfMonth = Integer.parseInt(configParts[0].substring(lparen + 1, rparen));
            config.MonthsOfYear = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
        } else {
            try {
                for (int i2 = 0; i2 < configParts[0].length(); i2 += 2) {
                    String day = configParts[0].substring(i2, i2 + 2);
                    int index = DAYS_OF_WEEK_STRING.indexOf(day);
                    System.out.println(String.format("day: %s, index: %d", day, index));
                    if (-1 == index) continue;
                    config.DaysOfWeek[index / 2] = true;
                    config._isWeekly = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!config._isWeekly) {
                try {
                    String month = configParts[0].substring(0, 3);
                    int index = MONTHS_OF_YEAR_STRING.indexOf(month);
                    System.out.println(String.format("month: %s, index: %d", month, index));
                    if (-1 != index) {
                        int lparen = configParts[0].indexOf("(");
                        int rparen = configParts[0].indexOf(")");
                        config._dayOfMonth = Integer.parseInt(configParts[0].substring(lparen + 1, rparen));
                        config.MonthsOfYear[index / 3] = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (config._isWeekly) {
            for (i = 0; i < 7; ++i) {
                System.out.println(" " + DAYS_OF_WEEK_STRING.substring(i * 2, (i + 1) * 2) + ": " + config.DaysOfWeek[i]);
            }
        } else {
            for (i = 0; i < 12; ++i) {
                System.out.println(" " + MONTHS_OF_YEAR_STRING.substring(i * 3, (i + 1) * 3) + ": " + config.MonthsOfYear[i]);
            }
        }
        StringTokenizer st = new StringTokenizer(configParts[1], ":");
        int hourOfDay = Integer.parseInt(st.nextToken());
        int minute = Integer.parseInt(st.nextToken());
        Calendar cal = Calendar.getInstance();
        cal.set(11, hourOfDay);
        cal.set(12, minute);
        cal.set(13, 0);
        if (Calendar.getInstance().after(cal)) {
            long t = cal.getTime().getTime();
            cal.setTime(new Date(t += 86400000L));
        }
        config.StartTime = cal.getTime();
        config.Interval = 86400000L;
        config.Action = configParts[2];
        return config;
    }
}

