/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integ.janoslib.messagepump.MessagePumpListener;
import com.integpg.janoslib.system.RegistryModifiedListener;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import com.integpg.system.SystemMsg;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RegistryMonitor
implements MessagePumpListener {
    private static final Hashtable<String, Long> _subscribedKeys = new Hashtable();
    private static final Vector _listeners = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToKey(String key, RegistryModifiedListener listener) {
        if (key.endsWith("/")) {
            key = key.substring(0, key.lastIndexOf("/"));
        }
        if (!_listeners.contains(listener)) {
            _listeners.addElement(listener);
        }
        long lastModified = JANOS.getRegistryLastModified((String)key);
        System.out.println("Last modified time for " + key + " was " + new Date(lastModified).toString());
        Hashtable<String, Long> hashtable = _subscribedKeys;
        synchronized (hashtable) {
            _subscribedKeys.put(key, new Long(lastModified));
        }
    }

    @Override
    public void messageReceived(SystemMsg systemMsg) {
        if (64 == systemMsg.type) {
            String registryKey = new String(systemMsg.msg);
            Enumeration<String> e = _subscribedKeys.keys();
            while (e.hasMoreElements()) {
                String subscribedKey = e.nextElement();
                if (-1 == registryKey.indexOf(subscribedKey)) continue;
                FileLogger.info("MessagePump", subscribedKey + " updated");
                long lastModified = JANOS.getRegistryLastModified((String)subscribedKey);
                long knownModified = _subscribedKeys.get(subscribedKey);
                System.out.println("Last modified time for " + subscribedKey + " was " + new Date(lastModified).toString());
                System.out.println(subscribedKey + " " + lastModified + " ?> " + knownModified);
                if (lastModified <= knownModified) continue;
                System.out.println(subscribedKey + " needs to be updated since " + knownModified);
                int listenerCount = _listeners.size();
                if (listenerCount > 0) {
                    for (int i = 0; i < listenerCount; ++i) {
                        RegistryModifiedListener listener = (RegistryModifiedListener)_listeners.elementAt(i);
                        listener.registryModified(registryKey);
                    }
                }
                _subscribedKeys.put(subscribedKey, new Long(lastModified));
            }
        }
    }
}

