/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.janoslib.http.server.HttpContext;
import com.integpg.janoslib.http.server.HttpResponse;
import com.integpg.janoslib.http.server.WebHandler;
import com.integpg.janoslib.io.AppLog;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class MacroExecuteWebHandler
implements WebHandler,
MacroRequestListener {
    private PrintWriter _out;

    @Override
    public void processRequest(HttpContext httpContext) {
        try {
            System.out.println(String.format("%lld MacroExecuteWebHandler request received", System.currentTimeMillis()));
            AppLog.info(String.format("Processing %s", httpContext.getRequest().getRequestedURI()));
            HttpResponse response = httpContext.getResponse();
            response.setContentType("text/html");
            this._out = response.getWriter();
            Hashtable<String, String> queryParams = httpContext.getRequest().getQueryParams();
            Enumeration<String> e = queryParams.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = queryParams.get(key);
                this._out.println(String.format("%s = %s", key, value));
                this._out.println("<br>");
            }
            this._out.println("<br>");
            try {
                String macroName = queryParams.get("name");
                if (null == macroName) {
                    throw new Exception("Script Name expected");
                }
                CinemaMain.MacroFile.runMacro(this, macroName);
            }
            catch (Exception ex) {
                this._out.println("error: " + ex.getMessage());
                ex.printStackTrace();
            }
            System.out.println(String.format("%lld MacroExecuteWebHandler request done", System.currentTimeMillis()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                httpContext.getRequest().close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        this._out.println(new Date() + " - " + macroResult.getResult() + ": " + macroResult.getReason());
        this._out.println("<br>");
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
        this._out.println(new Date() + " - " + updateString);
        this._out.println("<br>");
    }
}

