/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.macro;

import com.integpg.cinema.CinemaIO;
import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Config;
import com.integpg.cinema.Logic;
import com.integpg.cinema.devices.TheatreDevice;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.cinema.firealarm.FireAlarm;
import com.integpg.cinema.macro.ExternalDeviceAction;
import com.integpg.cinema.macro.FrontPanelLEDAction;
import com.integpg.cinema.macro.FrontPanelSoundAction;
import com.integpg.cinema.macro.InternalIOAction;
import com.integpg.cinema.macro.MacroAction;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.SoftPulseAction;
import com.integpg.cinema.macro.WakeOnLanAction;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import com.integpg.xchange.XChangeConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class Macro {
    private final Vector _actions = new Vector(10);
    private int _actionCount = 0;
    public static Hashtable _logicRulesByCommand = new Hashtable();
    private final String _name;
    private boolean _abort = false;
    public static long TotalTime = 0L;
    public static int TotalActions = 0;
    private MacroRequestListener _requester;
    private String _json = null;

    public Macro(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void addAction(int delta, String action) {
        long start = JANOS.uptimeMillis();
        String lowerCaseAction = action.toLowerCase();
        MacroAction foundMacroAction = null;
        int i = 0;
        for (i = 0; i < this._actionCount; ++i) {
            MacroAction ma = (MacroAction)this._actions.elementAt(i);
            if (ma.getDelay() != delta) continue;
            if (ma._lowerCaseAction.startsWith("cp") && lowerCaseAction.startsWith("cp") || ma._lowerCaseAction.startsWith("c") && lowerCaseAction.startsWith("c") || ma._lowerCaseAction.startsWith("o") && lowerCaseAction.startsWith("o") || ma._lowerCaseAction.startsWith("t") && lowerCaseAction.startsWith("t")) {
                foundMacroAction = ma;
                break;
            }
            ++delta;
            break;
        }
        if (foundMacroAction == null) {
            if (lowerCaseAction.startsWith("device_")) {
                if (lowerCaseAction.indexOf("_fpled") != -1) {
                    this.addAction(new FrontPanelLEDAction(action, delta));
                } else if (lowerCaseAction.indexOf("_fpsound") != -1) {
                    this.addAction(new FrontPanelSoundAction(action, delta));
                } else if (lowerCaseAction.indexOf("_pulse sms") != -1) {
                    this.addAction(new SoftPulseAction("SP" + Config.FEATURE_START_INPUT, delta));
                } else if (lowerCaseAction.indexOf("_wake on lan") != -1) {
                    this.addAction(new WakeOnLanAction(action, delta));
                } else {
                    this.addAction(new ExternalDeviceAction(action, delta));
                }
            } else if (lowerCaseAction.startsWith("sp")) {
                this.addAction(new SoftPulseAction(action, delta));
            } else {
                this.addAction(new InternalIOAction(action, delta));
            }
        } else if (foundMacroAction._lowerCaseAction.startsWith("cp") && action.toLowerCase().startsWith("cp")) {
            int _equalsPos = foundMacroAction._lowerCaseAction.indexOf("=");
            int equalsPos = action.indexOf("=");
            foundMacroAction.setAction(foundMacroAction._action.substring(0, _equalsPos) + action.substring(2, equalsPos) + foundMacroAction._action.substring(_equalsPos));
        } else if (foundMacroAction._lowerCaseAction.startsWith("c") && action.toLowerCase().startsWith("c") || foundMacroAction._lowerCaseAction.startsWith("o") && action.toLowerCase().startsWith("o") || foundMacroAction._lowerCaseAction.startsWith("t") && action.toLowerCase().startsWith("t")) {
            String channelString = action.substring(1, action.length());
            foundMacroAction.setAction(foundMacroAction._action.substring(0, foundMacroAction._action.length()) + channelString);
        } else {
            foundMacroAction.setAction(action.trim());
            FileLogger.info("Multiple Macro Actions at the Same Timing Mark");
        }
        long elapsed = JANOS.uptimeMillis() - start;
        TotalTime += elapsed;
        ++TotalActions;
    }

    public void setRequester(MacroRequestListener requester) {
        this._requester = requester;
    }

    public void abort() {
        this._abort = true;
    }

    private void addAction(MacroAction ma) {
        boolean inserted = false;
        for (int i = 0; i < this._actions.size(); ++i) {
            if (ma.getDelay() >= ((MacroAction)this._actions.elementAt(i)).getDelay()) continue;
            this._actions.insertElementAt(ma, i);
            inserted = true;
            break;
        }
        if (!inserted) {
            this._actions.addElement(ma);
        }
        ++this._actionCount;
    }

    public boolean execute(boolean checkPreshowLock) throws IOException {
        int i;
        Logic logic;
        int result;
        this._abort = false;
        XChangeConnection.getInstance().send(String.valueOf(UnitConfig.SERIAL_NUMBER), "update", "miscellaneous = " + this._name + " Started...");
        XChangeConnection.getInstance().send(String.valueOf(UnitConfig.SERIAL_NUMBER), "update", "alert = ");
        Object[] actions = new MacroAction[this._actions.size()];
        this._actions.copyInto(actions);
        long start = JANOS.uptimeMillis();
        boolean macroResult = true;
        String macroResultString = ", Macro Result = SUCCESS";
        long[] triggerTime = new long[this._actionCount];
        long[] actualTime = new long[this._actionCount];
        ArrayList<String> usedDevicesByName = new ArrayList<String>();
        for (int i2 = 0; i2 < this._actionCount; ++i2) {
            triggerTime[i2] = start + (long)((MacroAction)actions[i2]).getDelay();
        }
        String lowerName = this._name.toLowerCase();
        if (_logicRulesByCommand.containsKey(lowerName) && (result = (logic = (Logic)_logicRulesByCommand.get(lowerName)).evaluate(JANOS.getInputStates(), JANOS.getOutputStates())) == 0) {
            FileLogger.info("Defined Logic Prevented Macro");
            return false;
        }
        for (i = 0; i < this._actionCount; ++i) {
            try {
                boolean actionResult;
                String deviceName;
                long timeout = triggerTime[i] - JANOS.uptimeMillis();
                if (timeout > 0L) {
                    try {
                        Thread.sleep(timeout);
                    }
                    catch (InterruptedException ex) {
                        ExceptionHandler.logException(0, "Error trying to sleep", ex);
                    }
                }
                actualTime[i] = JANOS.uptimeMillis();
                if (checkPreshowLock) {
                    if (CinemaIO.getPreshowLock() == 1 || FireAlarm.m_fireAlarm == 1) {
                        FileLogger.info("Pre-show set, aborting macro execution.");
                        FileLogger.info("Action " + ((MacroAction)actions[i])._action + " ABORTED, Macro Result = ABORTED");
                        return false;
                    }
                } else if (this._abort) {
                    FileLogger.info("Aborting macro execution.");
                    this._requester.macroUpdate(this, "User Aborted", false);
                    return false;
                }
                Object action = actions[i];
                if (null != this._requester) {
                    this._requester.macroUpdate(this, ((MacroAction)action).getAction(), true);
                }
                ((MacroAction)action).run();
                if (action instanceof ExternalDeviceAction && !usedDevicesByName.contains(deviceName = ((ExternalDeviceAction)action).getDeviceName())) {
                    FileLogger.info("external device used: " + deviceName);
                    usedDevicesByName.add(deviceName);
                }
                if (!(actionResult = ((MacroAction)actions[i])._success) && macroResult) {
                    macroResultString = ", Macro Result = FAILED";
                }
                macroResult &= actionResult;
                String logEntryString = "Action " + ((MacroAction)actions[i])._action + (actionResult ? " SUCCESS" : " FAILED") + macroResultString;
                FileLogger.info(logEntryString);
                continue;
            }
            catch (Exception ex) {
                ExceptionHandler.logException(0, "Error executing action " + ((MacroAction)actions[i])._action, ex);
                ex.printStackTrace();
                macroResult = false;
                String logEntryString = "Action " + ((MacroAction)actions[i])._action + " FAILED" + macroResultString;
                FileLogger.error(logEntryString);
            }
        }
        if (null != this._requester) {
            if (macroResult) {
                this._requester.macroUpdate(this, "Complete", false);
            } else {
                this._requester.macroUpdate(this, "Failed", false);
            }
        }
        for (i = 0; i < this._actionCount; ++i) {
            Object macroAction = actions[i];
            while (!((MacroAction)macroAction)._completed) {
                try {
                    System.out.println("Action result: " + ((MacroAction)macroAction)._originalAction + " = " + ((MacroAction)macroAction)._success + " (" + ((MacroAction)macroAction)._completed + ")");
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            System.out.println("Action result: " + ((MacroAction)macroAction)._originalAction + " = " + ((MacroAction)macroAction)._success + " (" + ((MacroAction)macroAction)._completed + ")");
        }
        for (String deviceName : usedDevicesByName) {
            TheatreDevice device = (TheatreDevice)CinemaMain.INSTANCE.theatreDevices.get(deviceName);
            if (!(device instanceof TheatreEthernetDevice)) continue;
            FileLogger.info("Disconnect from " + deviceName);
            ((TheatreEthernetDevice)device).disconnect();
        }
        if (macroResult) {
            XChangeConnection.getInstance().send(String.valueOf(UnitConfig.SERIAL_NUMBER), "update", "miscellaneous = " + this._name + " Success");
        } else {
            XChangeConnection.getInstance().send(String.valueOf(UnitConfig.SERIAL_NUMBER), "update", "alert = " + this._name + " Failed");
        }
        System.out.println("Macro Complete");
        return macroResult;
    }

    public static void addLogic(String command, Logic logic) {
        _logicRulesByCommand.put(command, logic);
    }

    public String toJson() {
        if (this._json == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("{\"");
            sb.append(this._name);
            sb.append("\" : ");
            for (int i = 0; i < this._actionCount; ++i) {
                sb.append('{');
                sb.append(((MacroAction)this._actions.elementAt(i)).getDelay());
                sb.append(" : '");
                sb.append(((MacroAction)this._actions.elementAt((int)i))._action);
                sb.append("\"}");
                if (i + 1 >= this._actionCount) continue;
                sb.append(",");
            }
            this._json = sb.toString();
        }
        return this._json;
    }
}

