/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.client.CinemaServerClient;
import com.integpg.cinema.client.CinemaServerClientHandler;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class CinemaServerClientTcpServer
implements Runnable {
    private ServerSocket svrSocket;
    private Socket socket;
    private int m_port;
    private Thread theServer;
    private boolean bServerRun = true;
    private CinemaServerClient m_parent;
    private Vector clients = new Vector();

    public CinemaServerClientTcpServer(CinemaServerClient parent, int port) {
        this.m_parent = parent;
        this.m_port = port;
    }

    public void start() {
        FileLogger.info("Listen on port: " + this.m_port);
        try {
            this.svrSocket = new ServerSocket(this.m_port);
            this.theServer = new Thread((Runnable)this, "Cinema Server Client Server");
            this.theServer.start();
        }
        catch (Exception ex) {
            ExceptionHandler.logException(0, ex);
        }
    }

    public void stop() throws IOException {
        this.bServerRun = false;
        this.svrSocket.close();
        try {
            this.theServer.interrupt();
            this.theServer.join();
        }
        catch (InterruptedException ex) {
            ExceptionHandler.logException(0, ex);
        }
    }

    @Override
    public void run() {
        try {
            while (this.bServerRun) {
                try {
                    System.out.println("Listening for clients on port " + this.m_port + ".");
                    this.socket = this.svrSocket.accept();
                    System.out.println("Client connected " + JANOS.uptimeMillis());
                    CinemaServerClientHandler handler = new CinemaServerClientHandler(this.m_parent, this.socket.getInputStream(), this.socket.getOutputStream(), this.socket);
                    this.clients.addElement(handler);
                    Thread thd = new Thread((Runnable)handler, "Cinema Server Client Handler");
                    thd.setDaemon(true);
                    thd.start();
                }
                catch (IOException ex) {
                    ExceptionHandler.logException(0, ex);
                    this.bServerRun = false;
                }
                catch (Exception ex) {
                    ExceptionHandler.logException(0, ex);
                }
            }
        }
        catch (Exception ex) {
            if (this.bServerRun) {
                ExceptionHandler.logException(0, ex);
            }
            this.bServerRun = false;
        }
        try {
            this.svrSocket.close();
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, ex);
        }
        this.svrSocket = null;
    }

    public void remove(CinemaServerClientHandler clientHandler) {
        if (!this.clients.removeElement(clientHandler)) {
            System.out.println("Unable to remove client");
        }
    }

    void send(String message) throws IOException {
        Enumeration elements = this.clients.elements();
        while (elements.hasMoreElements()) {
            CinemaServerClientHandler handler = (CinemaServerClientHandler)elements.nextElement();
            handler.send(message);
        }
    }
}

