/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.Config;
import com.integpg.cinema.Logic;
import com.integpg.cinema.client.CinemaServerClientHandler;
import com.integpg.cinema.client.CinemaServerClientTcpServer;
import com.integpg.cinema.devices.TheatreDevice;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.SerialPort;
import com.integpg.comm.SerialPortEvent;
import com.integpg.comm.SerialPortEventListener;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.Log;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.logger.FileLogger;
import com.integpg.serial.SerialHelper;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class CinemaServerClient
extends TheatreDevice
implements SerialPortEventListener {
    public String REG_BASE = "AppData/Cinema/CinemaServerClient";
    public String REG_CLIENT_METHOD = this.REG_BASE + "/Method";
    public String REG_CLIENT_INCOMING_TERMINATION_STRING = this.REG_BASE + "/IncomingTerminationString";
    public String REG_CLIENT_OUTGOING_TERMINATION_STRING = this.REG_BASE + "/OutgoingTerminationString";
    public String REG_CLIENT_IO_ENABLED = this.REG_BASE + "/SerialCommandsEnabled";
    public String REG_CLIENT_UNSOLICITED_IO = this.REG_BASE + "/UnsolicitedIoAlerts";
    public String REG_CLIENT_SEND_COUNTS = this.REG_BASE + "/SendCounts";
    public String REG_CLIENT_TCP_PORT = this.REG_BASE + "/TcpPort";
    public String REG_CLIENT_SEND_ACK = this.REG_BASE + "/SendAck";
    public String REG_CLIENT_SEND_DATESTAMP = this.REG_BASE + "/SendDateStamp";
    public String REG_SERIAL = this.REG_BASE + "/Serial";
    public String REG_PAUSE_DELAY = this.REG_BASE + "/PauseDelay";
    public String REG_CLIENT_SEND_CONNECTED = this.REG_BASE + "/SendClientConnected";
    public String REG_SILENT = this.REG_BASE + "/Silent";
    public String CLIENT_METHOD = "disabled";
    public String CLIENT_INCOMING_TERMINATION_STRING = "\\r\\n";
    public byte[] CLIENT_INCOMING_TERMINATION_BYTES = this.getTerminationBytes(this.CLIENT_INCOMING_TERMINATION_STRING);
    public String CLIENT_OUTGOING_TERMINATION_STRING = "\\r\\n";
    public byte[] CLIENT_OUTGOING_TERMINATION_BYTES = this.getTerminationBytes(this.CLIENT_OUTGOING_TERMINATION_STRING);
    public boolean CLIENT_IO_ENABLED = false;
    public boolean CLIENT_UNSOLICITED_IO = false;
    public boolean CLIENT_SEND_COUNTS = false;
    public boolean CLIENT_SEND_ACK = true;
    public boolean CLIENT_SEND_DATESTAMP = true;
    public int CLIENT_TCP_PORT = -1;
    public static int PAUSE_DELAY = -1;
    public static Log CINEMA_SERVER_LOG = FileLog.getLog(new LogOptions("cinemaserver.log").setMaxFileSizeInKb(128));
    private SerialPort serial;
    private InputStream in;
    private OutputStream out;
    private Thread m_serialThread;
    private CinemaServerClientHandler m_serialHandler = null;
    CinemaServerClientTcpServer m_tcpServer = null;
    public static Hashtable _logicRulesByCommand = new Hashtable();

    public void serialEvent(SerialPortEvent ev) {
        AUXSerialPort aux = (AUXSerialPort)this.serial;
        switch (ev.getEventType()) {
            case 1: {
                CINEMA_SERVER_LOG.info("aux.CTS: " + aux.getCTS());
                break;
            }
            case 2: {
                CINEMA_SERVER_LOG.info("** parity error");
                break;
            }
            case 8: {
                CINEMA_SERVER_LOG.info("** framing error");
                break;
            }
            case 4: {
                CINEMA_SERVER_LOG.info("** overrun error");
                break;
            }
            case 64: {
                CINEMA_SERVER_LOG.info("** break condition");
                break;
            }
            default: {
                CINEMA_SERVER_LOG.info("** unknown event");
            }
        }
    }

    public CinemaServerClient() throws Exception {
        super("Cinema_Server_Client");
        this.getConfig();
        super.setHost("0.0.0.0");
    }

    public void start() {
        SerialHelper.getConfiguration(this.REG_SERIAL, "RS232");
        if (this.CLIENT_METHOD.toLowerCase().equals("serial")) {
            try {
                this.serial = SerialHelper.getSerialPort(this.REG_SERIAL, "RS232");
                if (this.serial instanceof AUXSerialPort) {
                    FileLogger.info("Add aux port serial event listener");
                    this.serial.addEventListener((SerialPortEventListener)this);
                    AUXSerialPort aux = (AUXSerialPort)this.serial;
                    CINEMA_SERVER_LOG.info("aux.CTS: " + aux.getCTS());
                    CINEMA_SERVER_LOG.info("aux.RTS: " + aux.getRTS());
                }
            }
            catch (Exception ex) {
                ExceptionHandler.logException(0, ex);
                ex.printStackTrace();
                return;
            }
            try {
                this.in = this.serial.getInputStream();
                this.out = this.serial.getOutputStream();
            }
            catch (IOException ex) {
                ExceptionHandler.logException(0, ex);
            }
            this.m_serialHandler = new CinemaServerClientHandler(this, this.in, this.out);
            this.m_serialThread = new Thread((Runnable)this.m_serialHandler, "Cinema Server Client Handler");
            this.m_serialThread.start();
        }
        if (this.CLIENT_TCP_PORT > 0) {
            FileLogger.info("Start Tcp Server:" + this.CLIENT_TCP_PORT);
            this.m_tcpServer = new CinemaServerClientTcpServer(this, this.CLIENT_TCP_PORT);
            this.m_tcpServer.start();
        }
    }

    public void getConfig() {
        FileLogger.info("Getting Cinema Server Client Configuration");
        this.CLIENT_METHOD = RegistryHelper.getRegistryKey(this.REG_CLIENT_METHOD, this.CLIENT_METHOD);
        String terminationString = JANOS.getRegistryString((String)this.REG_CLIENT_INCOMING_TERMINATION_STRING, (String)"");
        if (terminationString.equals("")) {
            terminationString = JANOS.getRegistryString((String)this.REG_CLIENT_INCOMING_TERMINATION_STRING, (String)this.CLIENT_INCOMING_TERMINATION_STRING);
        }
        this.CLIENT_INCOMING_TERMINATION_STRING = RegistryHelper.getRegistryKey(this.REG_CLIENT_INCOMING_TERMINATION_STRING, terminationString);
        this.CLIENT_INCOMING_TERMINATION_BYTES = this.getTerminationBytes(this.CLIENT_INCOMING_TERMINATION_STRING);
        this.CLIENT_INCOMING_TERMINATION_STRING = new String(this.CLIENT_INCOMING_TERMINATION_BYTES);
        terminationString = JANOS.getRegistryString((String)this.REG_CLIENT_OUTGOING_TERMINATION_STRING, (String)"");
        if (terminationString.equals("")) {
            terminationString = JANOS.getRegistryString((String)this.REG_CLIENT_OUTGOING_TERMINATION_STRING, (String)this.CLIENT_OUTGOING_TERMINATION_STRING);
        }
        this.CLIENT_OUTGOING_TERMINATION_STRING = RegistryHelper.getRegistryKey(this.REG_CLIENT_OUTGOING_TERMINATION_STRING, terminationString);
        if (!this.CLIENT_OUTGOING_TERMINATION_STRING.equalsIgnoreCase("none")) {
            this.CLIENT_OUTGOING_TERMINATION_BYTES = this.getTerminationBytes(this.CLIENT_OUTGOING_TERMINATION_STRING);
            this.CLIENT_OUTGOING_TERMINATION_STRING = new String(this.CLIENT_OUTGOING_TERMINATION_BYTES);
        } else {
            this.CLIENT_OUTGOING_TERMINATION_BYTES = new byte[0];
            this.CLIENT_OUTGOING_TERMINATION_STRING = "";
        }
        this.CLIENT_IO_ENABLED = RegistryHelper.getRegistryKey(this.REG_CLIENT_IO_ENABLED, this.CLIENT_IO_ENABLED);
        this.CLIENT_UNSOLICITED_IO = RegistryHelper.getRegistryKey(this.REG_CLIENT_UNSOLICITED_IO, this.CLIENT_UNSOLICITED_IO);
        this.CLIENT_SEND_COUNTS = RegistryHelper.getRegistryKey(this.REG_CLIENT_SEND_COUNTS, this.CLIENT_SEND_COUNTS);
        this.CLIENT_SEND_ACK = RegistryHelper.getRegistryKey(this.REG_CLIENT_SEND_ACK, this.CLIENT_SEND_ACK);
        this.CLIENT_SEND_DATESTAMP = RegistryHelper.getRegistryKey(this.REG_CLIENT_SEND_DATESTAMP, this.CLIENT_SEND_DATESTAMP);
        this.CLIENT_TCP_PORT = RegistryHelper.getRegistryKey(this.REG_CLIENT_TCP_PORT, this.CLIENT_TCP_PORT);
        PAUSE_DELAY = RegistryHelper.getRegistryKey(this.REG_PAUSE_DELAY, PAUSE_DELAY);
    }

    protected byte[] getTerminationBytes(String terminationString) {
        String newTermString = "";
        boolean backslashFound = false;
        for (int i = 0; i < terminationString.length(); ++i) {
            if (terminationString.charAt(i) == '\\' && !backslashFound) {
                backslashFound = true;
                continue;
            }
            if (backslashFound) {
                switch (terminationString.charAt(i)) {
                    case 'r': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'n': {
                        newTermString = newTermString + '\n';
                        break;
                    }
                    case 't': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'f': {
                        newTermString = newTermString + '\f';
                        break;
                    }
                    case 'b': {
                        newTermString = newTermString + '\b';
                        break;
                    }
                    case '0': {
                        newTermString = newTermString + '\u0000';
                    }
                }
            } else {
                newTermString = newTermString + terminationString.charAt(i);
            }
            backslashFound = false;
        }
        return newTermString.getBytes();
    }

    public void stop() {
        if (this.m_tcpServer != null) {
            try {
                this.m_tcpServer.stop();
            }
            catch (IOException ex) {
                ExceptionHandler.logException(0, ex);
            }
        }
    }

    public void send(String message) throws IOException {
        if (this.m_serialHandler != null) {
            this.m_serialHandler.send(message);
        }
        if (this.m_tcpServer != null) {
            this.m_tcpServer.send(message);
        }
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        System.out.println("Cinema Server Client Macro Execute");
        String lower = macroName.toLowerCase();
        if (lower.startsWith("send")) {
            String send = macroName.substring(5);
            String data = null;
            String converted = this.convertHexToString(send);
            data = converted != null ? converted : send;
            if (data == null) {
                FileLogger.warn(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            byte[] dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
            try {
                this.send(new String(dataBytes));
            }
            catch (IOException ex) {
                ExceptionHandler.logException(0, ex);
            }
        }
        return true;
    }

    public void addLogic(String command, Logic logic) {
        _logicRulesByCommand.put(command, logic);
    }
}

