/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integ.janoslib.messagepump.MessagePumpAppHandler;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integpg.cinema.AssemblyInfo;
import com.integpg.cinema.BootInfo;
import com.integpg.cinema.CinemaIO;
import com.integpg.cinema.Config;
import com.integpg.cinema.GetDeviceWebHandler;
import com.integpg.cinema.Logic;
import com.integpg.cinema.MacroExecuteWebHandler;
import com.integpg.cinema.Monitor.IOStateMonitor;
import com.integpg.cinema.ProtocolCommandMonitor;
import com.integpg.cinema.RegistryMonitor;
import com.integpg.cinema.RideThroughPowerMonitor;
import com.integpg.cinema.XChangeDevice;
import com.integpg.cinema.client.CinemaServerClient;
import com.integpg.cinema.client.JsonClientTcpServer;
import com.integpg.cinema.client.MessageEvent;
import com.integpg.cinema.client.MessageRepeaterListener;
import com.integpg.cinema.client.PreshowClient;
import com.integpg.cinema.configuration.CinemaConfiguration;
import com.integpg.cinema.devices.Barco;
import com.integpg.cinema.devices.Christie;
import com.integpg.cinema.devices.DolbyCP650Ethernet;
import com.integpg.cinema.devices.DolbyCP650Serial;
import com.integpg.cinema.devices.DolbyCP750Ethernet;
import com.integpg.cinema.devices.DolbyCP750Serial;
import com.integpg.cinema.devices.HttpRequest;
import com.integpg.cinema.devices.Jsd100Ethernet;
import com.integpg.cinema.devices.NEC;
import com.integpg.cinema.devices.NEC_VT700;
import com.integpg.cinema.devices.QSCDCP300Ethernet;
import com.integpg.cinema.devices.RawEthernet;
import com.integpg.cinema.devices.RawSerial;
import com.integpg.cinema.devices.RawUdp;
import com.integpg.cinema.devices.TheatreDevice;
import com.integpg.cinema.firealarm.FireAlarm;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroFile;
import com.integpg.cinema.messaging.CinemaSystemMessage;
import com.integpg.cinema.messaging.MacroExecuteEventHandler;
import com.integpg.cinema.messaging.MacroListEventHandler;
import com.integpg.cinema.messaging.ReleaseNotesListEventHandler;
import com.integpg.cinema.messaging.ReleaseNotesListResponseSystemMessage;
import com.integpg.frontpanel.FrontPanel;
import com.integpg.frontpanel.FrontPanelListener;
import com.integpg.janoslib.http.server.WebHandlerServer;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.ApplicationWatchdog;
import com.integpg.janoslib.system.DuplicateInstance;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.janoslib.system.RegistryModifiedListener;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import com.integpg.system.SystemMsg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Json;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class CinemaMain
implements MessageRepeaterListener,
FrontPanelListener,
RegistryModifiedListener {
    public static CinemaMain INSTANCE = null;
    private static final String FLASH_BACKUPS = "flash/cinema_backup";
    public static final String PRIVATE_ENTERPRISE = "1.3.6.1.4.1.";
    public static final String INTEG_PEN = "1.3.6.1.4.1.31976";
    public static final String CINEMA_OID = "1.3.6.1.4.1.31976.2";
    public static final String GENERAL_OID = "1.3.6.1.4.1.31976.2.1";
    public static final String STATUS_OID = "1.3.6.1.4.1.31976.2.2";
    public static final String TRAPS_OID = "1.3.6.1.4.1.31976.2.3";
    public static final String REBOOT_COUNT_OID = "1.3.6.1.4.1.31976.2.1.1.0";
    public static final String FIRE_ALARM_STATUS_OID = "1.3.6.1.4.1.31976.2.2.1.0";
    public static final String MOVIE_STATUS_OID = "1.3.6.1.4.1.31976.2.2.2.0";
    public static final String PRESHOW_LAMP_STATUS_OID = "1.3.6.1.4.1.31976.2.2.3.0";
    public static final String REBOOT_TRAP_OID = "1.3.6.1.4.1.31976.2.0.1";
    public static final String LOGS_TRAP_OID = "1.3.6.1.4.1.31976.2.0.2";
    public static final String PROJECTOR_TRAP_OID = "1.3.6.1.4.1.31976.2.0.3";
    public static final String SMS_TRAP_OID = "1.3.6.1.4.1.31976.2.0.4";
    public static final String FIRE_ALARM_TRAP_OID = "1.3.6.1.4.1.31976.2.0.5";
    public static final String LOGS_BAK_TRAP_OID = "1.3.6.1.4.1.31976.2.0.6";
    private static String DEVICES_FILE = null;
    private static final int DEVICE_NAME = 0;
    public static final int SET_OID_IPC_TYPE = 1040;
    public static final int SEND_TRAP_IPC_TYPE = 1041;
    public static final int SM_PROTCMDRESP = 113;
    public static final int PRODOKOL_IPC_TYPE = 1045;
    private Config _config;
    public static MacroFile MacroFile = new MacroFile();
    public IOStateMonitor m_stateMonitor;
    public static ProtocolCommandMonitor ProtocolCommandMonitor;
    private final MacroExecuteEventHandler _macroExecuteEventHandler = new MacroExecuteEventHandler();
    public PreshowClient clientComm;
    public CinemaServerClient cinemaServerClientComm;
    public Hashtable theatreDevices = new Hashtable();
    public FireAlarm fireAlarm;
    private long rebootCount = 0L;
    public CinemaIO cinemaio;
    public FrontPanel _frontPanel;
    private int _panelTriggerMask = 0;
    private String[] _panelTrigger = new String[24];
    public static Timer _timer;
    private JsonClientTcpServer _jsonClientTcpServer;
    private String _string;
    private int _pos;
    private String _deviceFile = null;
    private long _lastDeviceFileModification;
    private long _fileCheckLock = 0L;

    public static void main(String[] args) {
        Application.init(new AssemblyInfo());
        JANOS.setRegistryString((String)"AppData/Cinema/Version", (String)AssemblyInfo.getVersion());
        DuplicateInstance.exitOnDuplicateInstance();
        if (RegistryHelper.getRegistryKey("AppData/Cinema/Watchdog", false)) {
            ApplicationWatchdog watchdog = new ApplicationWatchdog(4);
            watchdog.start();
        }
        try {
            boolean debugLevelSet = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-debug")) {
                    FileLogger.setDebugLevel(16);
                    debugLevelSet = true;
                    continue;
                }
                if (!args[i].equalsIgnoreCase("-info")) continue;
                FileLogger.setDebugLevel(8);
                debugLevelSet = true;
            }
            if (!debugLevelSet) {
                FileLogger.setDebugLevel(8);
            }
            INSTANCE = new CinemaMain();
            INSTANCE.init();
            System.out.println("main thread entering hibernation");
            while (true) {
                System.out.println("*** " + new Date() + " ***");
                Thread.sleep(60000L - System.currentTimeMillis() % 60000L);
            }
        }
        catch (Exception ex) {
            FileLogger.error(ex);
            return;
        }
    }

    private void init() {
        int i;
        MessagePumpEngine.start();
        CinemaSystemMessage.setType(2000);
        ReleaseNotesListResponseSystemMessage systemMsg = new ReleaseNotesListResponseSystemMessage();
        MessagePumpEngine.postMessage(systemMsg.build());
        FileLogger.info("Update Reboot Count " + BootInfo.increment());
        try {
            FileLogger.info("Get Configuration");
            this._config = new Config();
            this._config.getConfig();
            CinemaConfiguration.init();
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, "Error getting configuration", ex);
        }
        TimerTask loadBalanceOutputTask = new TimerTask(){

            @Override
            public void run() {
                if (Config.LOAD_BALANCE_OUTPUT != -1) {
                    Calendar cal = Calendar.getInstance();
                    boolean state = cal.get(5) % 2 == 0;
                    FileLogger.info("Set Load Balance Output to " + (state ? "high" : "low"));
                    try {
                        JANOS.setOutputRelay((int)(Config.LOAD_BALANCE_OUTPUT - 1), (boolean)state);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        Calendar cal = Calendar.getInstance();
        int loadBalanceTriggerTime = cal.get(11) * 3600 + cal.get(12) * 60 + cal.get(13);
        loadBalanceTriggerTime = (86400 + (Config.LOAD_BALANCE_OFFSET - loadBalanceTriggerTime)) * 1000;
        _timer.schedule(loadBalanceOutputTask, loadBalanceTriggerTime %= 86400000, 86400000L);
        loadBalanceOutputTask.run();
        this._frontPanel = new FrontPanel();
        this.getPanelTriggerConfig();
        FileLogger.info("Ensure flash/cinema_backup exists");
        new File(FLASH_BACKUPS).mkdir();
        FileLogger.info("Initialize the IO Monitor");
        this.cinemaio = new CinemaIO();
        this.cinemaio.monitorPreshowLock();
        this.m_stateMonitor = new IOStateMonitor();
        try {
            FileLogger.info("Establish Client Comm");
            this.clientComm = new PreshowClient();
            this.clientComm.getConfig();
        }
        catch (NumberFormatException ex) {
            ExceptionHandler.logException(1, "Error establishing Client Communications", ex);
        }
        try {
            FileLogger.info("Establish Cinema Server Client Comm");
            this.cinemaServerClientComm = new CinemaServerClient();
        }
        catch (Exception ex) {
            if (ex.getMessage().equalsIgnoreCase("not enabled")) {
                this.cinemaServerClientComm = null;
            }
            ExceptionHandler.logException(2, "Error establishing Client Communications", ex);
        }
        try {
            File deviceFile = this.doFlashBackup("devices", ".csv", true);
            if (deviceFile != null) {
                File[] backedUpDeviceFiles = this.findFiles(FLASH_BACKUPS, "ipprofile", ".csv");
                if (backedUpDeviceFiles != null && backedUpDeviceFiles.length > 0) {
                    for (int i2 = 0; i2 < backedUpDeviceFiles.length; ++i2) {
                        backedUpDeviceFiles[i2].delete();
                    }
                }
            } else {
                deviceFile = this.doFlashBackup("ipprofile", ".csv", true);
            }
            if (deviceFile != null) {
                DEVICES_FILE = deviceFile.getAbsolutePath();
            }
            this.loadDevices();
        }
        catch (FileNotFoundException ex) {
            FileLogger.error("Devices File not found", ex);
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, "Error reading devices file", ex);
        }
        try {
            File macroFile = this.doFlashBackup("macro", ".csv", true);
            if (macroFile != null) {
                MacroFile.loadMacroFile(macroFile.getAbsolutePath());
            }
        }
        catch (FileNotFoundException ex) {
            FileLogger.error("Macro File not found", ex);
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, "Error reading macro file", ex);
        }
        try {
            int jsonTcpPort = CinemaConfiguration.getJsonTcpPort();
            if (0 < jsonTcpPort) {
                this._jsonClientTcpServer = new JsonClientTcpServer(jsonTcpPort);
                this._jsonClientTcpServer.start();
            }
        }
        catch (Exception ex) {
            AppLog.error("Error staarting Json Protocol Server", ex);
        }
        this.fireAlarm = new FireAlarm();
        if (Config.FIRE_ALARM_INPUT != -1) {
            FileLogger.info("Monitor Fire Alarm - INPUT " + Config.FIRE_ALARM_INPUT);
            this.m_stateMonitor.addStateListener(this.fireAlarm, 0, Config.FIRE_ALARM_INPUT);
        }
        if (Config.FIRE_ALARM_RELEASE_INPUT != -1) {
            FileLogger.info("Monitor Fire Alarm Release - INPUT " + Config.FIRE_ALARM_RELEASE_INPUT);
            this.m_stateMonitor.addStateListener(this.fireAlarm, 0, Config.FIRE_ALARM_RELEASE_INPUT);
        }
        for (i = 1; i <= UnitConfig.getInputCount(); ++i) {
            this.m_stateMonitor.addStateListener(this.cinemaio, 0, i);
        }
        for (i = 1; i <= 16; ++i) {
            this.m_stateMonitor.addStateListener(this.cinemaio, 1, i);
        }
        FileLogger.info("Start the IO Monitor");
        this.m_stateMonitor.start();
        FileLogger.info("Ensure IO Logging Enabled");
        JANOS.setRegistryString((String)"IO/Log", (String)"enabled");
        this.sendTrap(REBOOT_TRAP_OID, "DCAS Reboot - Count = " + this.rebootCount);
        TimerTask rebootTrapTask = new TimerTask(){

            @Override
            public void run() {
                CinemaMain.this.sendTrap(CinemaMain.REBOOT_TRAP_OID, "DCAS Reboot Clear");
            }
        };
        _timer.schedule(rebootTrapTask, 1800000L);
        this.setSnmpOidValue(REBOOT_COUNT_OID, String.valueOf(this.rebootCount), Config.COMMUNITY_NAME);
        try {
            MessagePumpEngine.addListener(new RideThroughPowerMonitor());
            ProtocolCommandMonitor = new ProtocolCommandMonitor();
            MessagePumpEngine.addListener(ProtocolCommandMonitor);
            MessagePumpAppHandler snapAppListener = new MessagePumpAppHandler(2000).addCommandListener("releasenotes.list", new ReleaseNotesListEventHandler()).addCommandListener("macro.list", new MacroListEventHandler()).addCommandListener("macro.execute", this._macroExecuteEventHandler);
            MessagePumpEngine.addListener(snapAppListener);
            FileLogger.info("Connected to Inter-Process Server");
        }
        catch (Exception ex) {
            ExceptionHandler.logException(0, "Error connecting to InterProcess Server", ex);
        }
        if (this.clientComm != null) {
            this.clientComm.start();
        }
        if (this.cinemaServerClientComm != null) {
            this.cinemaServerClientComm.start();
        }
        try {
            FileLogger.info("Register InterProcess Macro Command");
            ProtocolCommandMonitor.setLocalHook("macro", ProtocolCommandMonitor);
            FileLogger.info("Register InterProcess Get OID Values Command");
            ProtocolCommandMonitor.setLocalHook("getOIDValues", ProtocolCommandMonitor);
            FileLogger.info("Register InterProcess Macro List Command");
            ProtocolCommandMonitor.setLocalHook("macro_list", ProtocolCommandMonitor);
            ProtocolCommandMonitor.setLocalHook("app_registration", ProtocolCommandMonitor);
            this.getSnmpOidValues();
        }
        catch (Exception ex) {
            ExceptionHandler.logException(0, "Error registering InterProcess Commands", ex);
        }
        if (this._frontPanel.getPanels().length > 0) {
            FileLogger.info("Monitor Control Panels");
            try {
                this._frontPanel.resetPanels();
                this._frontPanel.addListener(this);
                this.setPanelConfig();
                this._frontPanel.monitorSwitches(this._panelTriggerMask != 0 ? 1000 : 10000);
            }
            catch (Exception ex) {
                ExceptionHandler.logException(0, "Error configuring User Control Panels", ex);
            }
        }
        RegistryHelper.getRegistryKey("AppData/Cinema/Logic/LogicRule1", "none");
        RegistryHelper.getRegistryKey("AppData/Cinema/Logic/LogicRule2", "none");
        RegistryHelper.getRegistryKey("AppData/Cinema/Logic/LogicRule3", "none");
        FileLogger.info("Get Logic Rules");
        String[] logicKeys = JANOS.getRegistryList((String)"AppData/Cinema/Logic");
        int logicKeyCount = logicKeys.length;
        for (int i3 = 0; i3 < logicKeyCount; ++i3) {
            String[] logicParts;
            if (logicKeys[i3] == null || (logicParts = JANOS.getRegistryKey((String)("AppData/Cinema/Logic/" + logicKeys[i3]))).length < 2) continue;
            String cause = logicParts[0];
            String logicString = logicParts[1];
            String action = "";
            if (logicParts.length >= 3) {
                action = logicParts[2];
            }
            Logic logic = new Logic(logicString, action);
            if (cause.equalsIgnoreCase("oniochange")) {
                this.cinemaio.addLogic(logic);
                continue;
            }
            if (cause.toLowerCase().startsWith("onpreshowclient(")) {
                cause = cause.substring(16, cause.length() - 1);
                this.clientComm.addLogic(cause, logic);
                continue;
            }
            if (cause.toLowerCase().startsWith("oncinemaserver(")) {
                cause = cause.substring(15, cause.length() - 1);
                this.cinemaServerClientComm.addLogic(cause, logic);
                continue;
            }
            if (!cause.toLowerCase().startsWith("onmacro(")) continue;
            cause = cause.substring(8, cause.length() - 1).toLowerCase();
            Macro.addLogic(cause, logic);
        }
        String macroOnBoot = RegistryHelper.getRegistryKey("AppData/Cinema/MACROS/OnBoot", "none");
        if (!macroOnBoot.equalsIgnoreCase("none") && MacroFile.runMacro(null, macroOnBoot).getResult()) {
            FileLogger.info("Executed OnBoot Macro - " + macroOnBoot);
        }
        TimerTask fileMonitorTask = new TimerTask(){

            @Override
            public void run() {
                INSTANCE.checkFiles();
                _timer.schedule((TimerTask)this, 10000L);
            }
        };
        _timer.schedule(fileMonitorTask, 10000L);
        RegistryMonitor registryMonitor = new RegistryMonitor();
        MessagePumpEngine.addListener(registryMonitor);
        registryMonitor.subscribeToKey("AppData/Cinema/Triggers/", this._config);
        registryMonitor.subscribeToKey("AppData/Cinema/Panel/", this);
        registryMonitor.subscribeToKey("Device/ControlPanel/", this);
        registryMonitor.subscribeToKey("AppData/Cinema/Client/Timers/", this.clientComm);
        registryMonitor.subscribeToKey("AppData/Cinema/$RunMacro", this);
        registryMonitor.subscribeToKey("AppData/Cinema/Commands", this._macroExecuteEventHandler);
        this.initWebServer();
        FileLogger.info("Application Loaded");
        JANOS.pulseStatusLED((int)100, (int)100, (int)25);
        this.waitForUserInput();
    }

    public void waitForUserInput() {
        Thread.currentThread().setName("Wait for user input");
        while (true) {
            try {
                if (System.in != null && System.in.available() > 0) {
                    int c = System.in.read();
                    this.onUserInput(c);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.out);
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }

    public void onUserInput(int c) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        switch (c) {
            case 120: {
                System.exit(0);
                break;
            }
            case 109: {
                try {
                    System.out.print("Enter Macro Name or Number: ");
                    String macroName = in.readLine();
                    MacroFile.runMacro(MacroFile, macroName);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 98: {
                System.out.print("Enter Control Panel LED Brightness (0 - 10)");
                try {
                    String brightnessString = in.readLine();
                    int brightness = Integer.parseInt(brightnessString);
                    this._frontPanel.setLedBrightness((byte)(brightness * 25));
                }
                catch (Exception ex) {
                    System.out.println("Invalid Volume Level");
                }
                break;
            }
            case 118: {
                System.out.print("Enter Control Panel Volume level (0 - 10)");
                try {
                    String volumeString = in.readLine();
                    int volume = Integer.parseInt(volumeString);
                    this._frontPanel.setVolume((byte)(volume * 25));
                }
                catch (Exception ex) {
                    System.out.println("Invalid Volume Level");
                }
                break;
            }
            case 114: {
                try {
                    this._frontPanel.resetPanels();
                    break;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void getPanelTriggerConfig() {
        FileLogger.info("Getting Front Panel Configuration");
        this._panelTriggerMask = 0;
        for (int i = 0; i < 12; ++i) {
            this._panelTrigger[i] = RegistryHelper.getRegistryKey("AppData/Cinema/Panel/Trigger" + (i + 1), "none");
            if (this._panelTrigger[i].equals("none")) continue;
            this._panelTriggerMask |= 1 << i;
        }
    }

    private File doFlashBackup(String prefix, String suffix, boolean restore) {
        File[] files = this.findFiles(Config.FILE_LOCATION, prefix, suffix);
        if (files == null || files.length == 0) {
            if (restore) {
                File[] backedUpFiles = this.findFiles(FLASH_BACKUPS, prefix, suffix);
                if (backedUpFiles != null && backedUpFiles.length > 0) {
                    for (int i = 0; i < backedUpFiles.length; ++i) {
                    }
                    FileLogger.info("Restore " + backedUpFiles[0].getAbsolutePath());
                    CinemaMain.copyfile(backedUpFiles[0].getAbsolutePath(), Config.FILE_LOCATION + "/" + backedUpFiles[0].getName());
                    files = new File[]{new File(Config.FILE_LOCATION + "/" + backedUpFiles[0].getName())};
                }
                backedUpFiles = null;
            }
        } else {
            System.out.println("Found " + files.length + " " + prefix + " file(s)");
            for (int i = 0; i < files.length; ++i) {
                System.out.println("  Found " + files[i]);
            }
            File[] backedUpFiles = this.findFiles(FLASH_BACKUPS, prefix, suffix);
            if (backedUpFiles != null || backedUpFiles.length > 0) {
                System.out.println("Found " + backedUpFiles.length + " file(s)");
                for (int i = 0; i < backedUpFiles.length; ++i) {
                    if (files[0].getName().equals(backedUpFiles[i].getName())) continue;
                    backedUpFiles[i].delete();
                }
            }
            System.out.println("Copy " + files[0] + " to " + FLASH_BACKUPS + " and use it");
            FileLogger.info("Backup " + files[0].getAbsolutePath());
            CinemaMain.copyfile(files[0].getAbsolutePath(), "flash/cinema_backup/" + files[0].getName());
            backedUpFiles = null;
        }
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    private File[] findFiles(String path, final String prefix, final String suffix) {
        File dir = new File(path);
        FilenameFilter fileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.startsWith(prefix) && name.endsWith(suffix)) {
                    File file = new File("/" + dir.getPath() + "/" + name);
                    return !file.isDirectory();
                }
                return false;
            }
        };
        String[] fileNames = dir.list(fileFilter);
        if (fileNames != null) {
            File[] files = new File[fileNames.length];
            for (int i = 0; i < fileNames.length; ++i) {
                files[i] = new File(path + "/" + fileNames[i]);
            }
            return files;
        }
        return null;
    }

    private static void copyfile(String srFile, String dtFile) {
        try {
            int len;
            File f1 = new File(srFile);
            File f2 = new File(dtFile);
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            buf = null;
        }
        catch (FileNotFoundException ex) {
            ExceptionHandler.logException(0, ex.getMessage() + " in the specified directory.", ex);
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, "Error copying " + srFile + " to " + dtFile, ex);
        }
    }

    private void loadDevices() throws FileNotFoundException, IOException {
        String line;
        Enumeration devices = this.theatreDevices.keys();
        while (devices.hasMoreElements()) {
            String deviceName = (String)devices.nextElement();
            ((TheatreDevice)this.theatreDevices.get(deviceName)).disconnect();
        }
        this.theatreDevices = new Hashtable();
        this.theatreDevices.put("cinema_manager", XChangeDevice.getInstance());
        this.theatreDevices.put("preshow_client", this.clientComm);
        this.theatreDevices.put("cinema_server_client", this.cinemaServerClientComm);
        if (DEVICES_FILE == null) {
            return;
        }
        FileLogger.info("Loading Devices File " + DEVICES_FILE);
        this._deviceFile = null;
        boolean DEVICES = true;
        BufferedReader br = new BufferedReader(new FileReader(new File(DEVICES_FILE)));
        boolean state = false;
        boolean deviceColumn = false;
        while ((line = br.readLine()) != null) {
            String s;
            boolean col = false;
            StringTokenizer st = new StringTokenizer(line, ",", true);
            if (!st.hasMoreTokens()) continue;
            try {
                s = st.nextToken();
            }
            catch (NoSuchElementException ex) {
                ExceptionHandler.logException(11, "Error loading devices file", ex);
                return;
            }
            if (state != DEVICES) {
                if (!s.equals("Device Name")) continue;
                state = DEVICES;
                continue;
            }
            if (state != DEVICES) continue;
            String name = s.toLowerCase();
            System.out.println("DeviceName: " + name);
            TheatreDevice device = null;
            try {
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    s = st.nextToken();
                }
            }
            catch (NoSuchElementException ex) {
                ExceptionHandler.logException(12, "Error loading devices file", ex);
                return;
            }
            System.out.println("Type is " + s);
            if (s.equals("BARCO")) {
                FileLogger.info("Establish " + name + " Comm - BARCO");
                device = new Barco(name);
            } else if (s.equals("CHRISTIE")) {
                FileLogger.info("Establish " + name + " Comm - CHRISTIE");
                device = new Christie(name);
            } else if (s.equals("NEC")) {
                FileLogger.info("Establish " + name + " Comm - NEC");
                device = new NEC(name);
            } else if (s.equals("NEC SERIES 2")) {
                FileLogger.info("Establish " + name + " Comm - NEC");
                device = new NEC(name);
            } else if (s.equalsIgnoreCase("NEC VT700 SERIAL")) {
                FileLogger.info("Establish " + name + " Comm - NEC_VT700");
                device = new NEC_VT700(name);
            } else if (s.equalsIgnoreCase("USL JSD100 ETHERNET")) {
                FileLogger.info("Establish " + name + " Comm - USL JSD100 ETHERNET");
                device = new Jsd100Ethernet(name);
            } else if (s.equalsIgnoreCase("DOLBY CP650 SERIAL")) {
                FileLogger.info("Establish " + name + " Comm - DOLBY CP650 SERIAL");
                device = new DolbyCP650Serial(name);
            } else if (s.equalsIgnoreCase("DOLBY CP650 ETHERNET")) {
                FileLogger.info("Establish " + name + " Comm - DOLBY CP650 ETHERNET");
                device = new DolbyCP650Ethernet(name);
            } else if (s.equalsIgnoreCase("DOLBY CP750 SERIAL")) {
                FileLogger.info("Establish " + name + " Comm - DOLBY CP750 SERIAL");
                device = new DolbyCP750Serial(name);
            } else if (s.equalsIgnoreCase("DOLBY CP750 ETHERNET")) {
                FileLogger.info("Establish " + name + " Comm - DOLBY CP750 ETHERNET");
                device = new DolbyCP750Ethernet(name);
            } else if (s.equalsIgnoreCase("QSC DCP300 ETHERNET")) {
                FileLogger.info("Establish " + name + " Comm - QSC DCP300 ETHERNET");
                device = new QSCDCP300Ethernet(name);
            } else if (s.equals("RAW SERIAL")) {
                FileLogger.info("Establish " + name + " Comm - Raw Serial");
                device = new RawSerial(name);
            } else if (s.equals("RAW ETHERNET")) {
                FileLogger.info("Establish " + name + " Comm - Raw Ethernet");
                device = new RawEthernet(name);
            } else if (s.equals("RAW UDP")) {
                FileLogger.info("Establish " + name + " Comm - Raw UDP");
                device = new RawUdp(name);
            } else if (s.equals("HTTP Request")) {
                FileLogger.info("HTTP Request");
                device = new HttpRequest(name);
            }
            if (device == null) continue;
            this.theatreDevices.put(name.toLowerCase(), device);
            try {
                String pass;
                String user;
                String terminationString;
                String stopBits;
                String parity;
                String dataBits;
                String baud;
                String sport;
                String shost;
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if ((shost = this.getNextToken(st)) != null) {
                    device.setHost(shost);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                }
                if ((sport = this.getNextToken(st)) != null) {
                    device.setPort(sport);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                }
                if ((baud = this.getNextToken(st)) != null) {
                    device.setBaud(Integer.valueOf(baud));
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                }
                if ((dataBits = this.getNextToken(st)) != null) {
                    device.setDataBits(Integer.valueOf(dataBits));
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                }
                if ((parity = this.getNextToken(st)) != null) {
                    device.setParity(parity);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                }
                if ((stopBits = this.getNextToken(st)) != null) {
                    device.setStopBits(Double.valueOf(stopBits));
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                }
                if ((terminationString = this.getNextToken(st)) != null) {
                    device.setTerminationString(terminationString);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                }
                if ((user = this.getNextToken(st)) != null) {
                    device.setUserName(user);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                }
                if ((pass = this.getNextToken(st)) == null) continue;
                device.setPassword(pass);
            }
            catch (NoSuchElementException ex) {
                ExceptionHandler.logException(13, "Error loading devices file", ex);
                return;
            }
        }
        br.close();
        FileLogger.info("Devices File Loaded");
        this._lastDeviceFileModification = new File(DEVICES_FILE).lastModified();
        this._deviceFile = DEVICES_FILE;
    }

    private String getNextToken(String delim, boolean skipDelim) throws Exception {
        int pos = this._string.length();
        if (this._pos == pos) {
            ++this._pos;
            return "";
        }
        if (this._pos >= pos) {
            return null;
        }
        while (true) {
            if ((pos = this._string.indexOf(delim, this._pos)) == -1) {
                if (this._pos < this._string.length()) {
                    pos = this._string.length();
                } else {
                    throw new NoSuchElementException();
                }
            }
            if (pos >= this._pos) break;
            ++this._pos;
        }
        String token = this._string.substring(this._pos, pos);
        this._pos = pos;
        if (skipDelim) {
            this._pos += delim.length();
        }
        token = token.trim();
        return token;
    }

    private String getNextToken(StringTokenizer st) {
        if (!st.hasMoreTokens()) {
            return null;
        }
        String s = st.nextToken().toString();
        if (s.equals(",")) {
            return null;
        }
        return s;
    }

    public void sendTrap(String oid, String trapMsg) {
        Json trapJson = new Json();
        trapJson.put("command", (Object)"update-oids");
        trapJson.put("oid", (Object)oid);
        trapJson.put("type", (Object)"string");
        trapJson.put("value", (Object)trapMsg);
        System.out.println("send trap: " + trapJson.toString());
        SystemMsg msg = new SystemMsg();
        msg.type = 3001;
        msg.msg = trapJson.toString().getBytes();
        MessagePumpEngine.postMessage(msg);
    }

    public void setSnmpOidValue(String oid, String value, String communityName) {
        Vector<Json> snmpJsonList = new Vector<Json>();
        Json oidJson = new Json();
        oidJson.put("oid", (Object)oid);
        oidJson.put("type", (Object)"string");
        oidJson.put("value", (Object)value);
        snmpJsonList.addElement(oidJson);
        Json snmpUpdateJson = new Json();
        snmpUpdateJson.put("command", (Object)"update-oids");
        Object[] jsonArray = new Json[snmpJsonList.size()];
        snmpJsonList.copyInto(jsonArray);
        snmpUpdateJson.put("oids", (Object)jsonArray);
        System.out.println("snmpUpdateJson: " + snmpUpdateJson);
        SystemMsg msg = new SystemMsg();
        msg.type = 3000;
        msg.msg = snmpUpdateJson.toString().getBytes();
        MessagePumpEngine.postMessage(msg);
    }

    public void setSnmpOidValue(String oid, int value, String communityName) {
        Vector<Json> snmpJsonList = new Vector<Json>();
        Json oidJson = new Json();
        oidJson.put("oid", (Object)oid);
        oidJson.put("type", (Object)"integer");
        oidJson.put("value", value);
        snmpJsonList.addElement(oidJson);
        Json snmpUpdateJson = new Json();
        snmpUpdateJson.put("command", (Object)"update-oids");
        Object[] jsonArray = new Json[snmpJsonList.size()];
        snmpJsonList.copyInto(jsonArray);
        snmpUpdateJson.put("oids", (Object)jsonArray);
        System.out.println("snmpUpdateJson: " + snmpUpdateJson);
        SystemMsg msg = new SystemMsg();
        msg.type = 3000;
        msg.msg = snmpUpdateJson.toString().getBytes();
        MessagePumpEngine.postMessage(msg);
    }

    public void getSnmpOidValues() {
        this.setSnmpOidValue(REBOOT_COUNT_OID, String.valueOf(this.rebootCount), Config.COMMUNITY_NAME);
        if (this.fireAlarm.getFireAlarmStatus() == 1) {
            this.setSnmpOidValue(FIRE_ALARM_STATUS_OID, 1, Config.COMMUNITY_NAME);
        } else {
            this.setSnmpOidValue(FIRE_ALARM_STATUS_OID, 0, Config.COMMUNITY_NAME);
        }
        if (CinemaIO.getMovieStatus() == 1) {
            this.setSnmpOidValue(MOVIE_STATUS_OID, 1, Config.COMMUNITY_NAME);
        } else {
            this.setSnmpOidValue(MOVIE_STATUS_OID, 0, Config.COMMUNITY_NAME);
        }
        if (CinemaIO.getPreshowLamp() == 1) {
            this.setSnmpOidValue(PRESHOW_LAMP_STATUS_OID, 1, Config.COMMUNITY_NAME);
        } else {
            this.setSnmpOidValue(PRESHOW_LAMP_STATUS_OID, 0, Config.COMMUNITY_NAME);
        }
    }

    @Override
    public void messageSendRequest(MessageEvent e) {
        System.out.println(e.getMessage());
    }

    @Override
    public boolean switchesPressed(Object source, int channelMask) {
        FrontPanel panel = (FrontPanel)source;
        int $channelMask = channelMask;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 12 & channelMask != 0) {
            if (($channelMask & 1) == 1) {
                if (!this._panelTrigger[i].equalsIgnoreCase("none")) {
                    MacroFile.runMacro(MacroFile, this._panelTrigger[i]);
                }
                sb.append(i + 1);
                sb.append(' ');
            }
            $channelMask >>= 1;
            ++i;
        }
        return true;
    }

    @Override
    public boolean switchPressed(Object source, int channel, int count) {
        FrontPanel panel = (FrontPanel)source;
        return true;
    }

    private void setPanelConfig() {
        try {
            int volume = RegistryHelper.getRegistryKey("Device/ControlPanel/DefaultVolume", 100);
            volume = Math.max(0, volume);
            volume = Math.min(100, volume);
            this._frontPanel.setVolume((byte)((double)volume * 2.5));
        }
        catch (Exception ex) {
            ExceptionHandler.logException(0, "Error setting default panel volume", ex);
        }
        try {
            int brightness = RegistryHelper.getRegistryKey("Device/ControlPanel/LEDBrightness", 100);
            brightness = Math.max(0, brightness);
            brightness = Math.min(100, brightness);
            this._frontPanel.setLedBrightness((byte)((double)brightness * 2.5));
        }
        catch (Exception ex) {
            ExceptionHandler.logException(0, "Error setting default panel brightness", ex);
        }
    }

    @Override
    public void registryModified(String key) {
        String macroName;
        System.out.println("Registry Modified: " + key);
        if (key.equalsIgnoreCase("appdata/cinema/panel/")) {
            this.getPanelTriggerConfig();
        } else if (key.equalsIgnoreCase("device/controlpanel/")) {
            this.setPanelConfig();
        } else if (key.endsWith("$RunMacro") && !"".equals(macroName = JANOS.getRegistryString((String)key, (String)""))) {
            JANOS.setRegistryString((String)key, (String)"");
            System.out.println("registry update run macro: " + macroName);
            MacroFile.runMacro(null, macroName);
        }
    }

    public void checkFiles() {
        block40: {
            long lastModified;
            block39: {
                if (JANOS.uptimeMillis() - this._fileCheckLock < 90000L) {
                    return;
                }
                this._fileCheckLock = JANOS.uptimeMillis();
                if (this._deviceFile != null) {
                    lastModified = new File(this._deviceFile).lastModified();
                    if (lastModified != this._lastDeviceFileModification) {
                        this._lastDeviceFileModification = lastModified;
                        try {
                            if (lastModified == 0L) {
                                DEVICES_FILE = null;
                                try {
                                    File deviceFile = this.doFlashBackup("devices", ".csv", false);
                                    if (deviceFile != null) {
                                        File[] backedUpDeviceFiles = this.findFiles(FLASH_BACKUPS, "ipprofile", ".csv");
                                        if (backedUpDeviceFiles != null && backedUpDeviceFiles.length > 0) {
                                            for (int i = 0; i < backedUpDeviceFiles.length; ++i) {
                                                backedUpDeviceFiles[i].delete();
                                            }
                                        }
                                    } else {
                                        deviceFile = this.doFlashBackup("ipprofile", ".csv", false);
                                    }
                                    if (deviceFile != null) {
                                        DEVICES_FILE = deviceFile.getAbsolutePath();
                                        this.loadDevices();
                                        JANOS.pulseStatusLED((int)100, (int)100, (int)10);
                                    }
                                    break block39;
                                }
                                catch (FileNotFoundException ex) {
                                    FileLogger.error("Devices File not found", ex);
                                }
                                catch (IOException ex) {
                                    ExceptionHandler.logException(1, "Error reading devices file", ex);
                                }
                                break block39;
                            }
                            this.loadDevices();
                            JANOS.pulseStatusLED((int)100, (int)100, (int)10);
                        }
                        catch (FileNotFoundException ex) {
                            ExceptionHandler.logException(2, "Error reading devices file", ex);
                        }
                        catch (IOException ex) {
                            ExceptionHandler.logException(3, "Error reading devices file", ex);
                        }
                    }
                } else {
                    try {
                        File deviceFile = this.doFlashBackup("devices", ".csv", false);
                        if (deviceFile != null) {
                            File[] backedUpDeviceFiles = this.findFiles(FLASH_BACKUPS, "ipprofile", ".csv");
                            if (backedUpDeviceFiles != null && backedUpDeviceFiles.length > 0) {
                                for (int i = 0; i < backedUpDeviceFiles.length; ++i) {
                                    backedUpDeviceFiles[i].delete();
                                }
                            }
                        } else {
                            deviceFile = this.doFlashBackup("ipprofile", ".csv", false);
                        }
                        if (deviceFile != null) {
                            DEVICES_FILE = deviceFile.getAbsolutePath();
                            this.loadDevices();
                            JANOS.pulseStatusLED((int)100, (int)100, (int)10);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        ExceptionHandler.logException(4, "Error reading devices file", ex);
                    }
                    catch (IOException ex) {
                        ExceptionHandler.logException(5, "Error reading devices file", ex);
                    }
                }
            }
            if (MacroFile.getMacroFile() != null) {
                lastModified = new File(MacroFile.getMacroFile()).lastModified();
                if (lastModified != MacroFile.getLastModified()) {
                    try {
                        if (lastModified == 0L) {
                            try {
                                File macroFile = this.doFlashBackup("macro", ".csv", false);
                                if (macroFile != null) {
                                    MacroFile.loadMacroFile(macroFile.getAbsolutePath());
                                    JANOS.pulseStatusLED((int)100, (int)100, (int)10);
                                }
                                break block40;
                            }
                            catch (FileNotFoundException ex) {
                                FileLogger.error("Macro File not found", ex);
                            }
                            catch (IOException ex) {
                                ExceptionHandler.logException(1, "Error reading macro file", ex);
                            }
                            break block40;
                        }
                        File macroFile = this.doFlashBackup("macro", ".csv", false);
                        MacroFile.loadMacroFile(MacroFile.getMacroFile());
                        JANOS.pulseStatusLED((int)100, (int)100, (int)10);
                    }
                    catch (FileNotFoundException ex) {
                        ExceptionHandler.logException(2, "Error reading macro file", ex);
                    }
                    catch (IOException ex) {
                        ExceptionHandler.logException(3, "Error reading macro file", ex);
                    }
                }
            } else {
                try {
                    File macroFile = this.doFlashBackup("macro", ".csv", false);
                    if (macroFile != null) {
                        MacroFile.loadMacroFile(macroFile.getAbsolutePath());
                        JANOS.pulseStatusLED((int)100, (int)100, (int)10);
                    }
                }
                catch (FileNotFoundException ex) {
                    ExceptionHandler.logException(4, "Error reading macro file", ex);
                }
                catch (IOException ex) {
                    ExceptionHandler.logException(5, "Error reading macro file", ex);
                }
            }
        }
        this._fileCheckLock = 0L;
    }

    private void initWebServer() {
        int port = Config.getWebServerPort();
        if (-1 != port) {
            WebHandlerServer webHandlerServer = new WebHandlerServer();
            webHandlerServer.addWebHandler("/macro", new MacroExecuteWebHandler());
            webHandlerServer.addWebHandler("/getdevice", new GetDeviceWebHandler());
            webHandlerServer.start(port);
        }
    }

    static {
        _timer = new Timer(true);
    }
}

